<!DOCTYPE html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include 'partials/head.php';
?>
<body class="">
<?php
include 'partials/header.php';
?>
<div class="breadcumb-wrapper background-image" style="background-image: url(assets/images/banner.jpg);">
    <div class="breadcumb-overlay" data-bg-src="assets/img/bg/breadcumb-bg-overlay.png"></div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">Enerji izleme çözümleri ile üretimde verimlilik</h1>
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Anasayfa</a></li>
                        <li>Blog</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<section class="th-blog-wrapper blog-details overflow-hidden space-top space-extra2-bottom">
    <div class="container">
        <div class="row gx-40">
            <div class="col-xxl-8 col-lg-7">
                <div class="th-blog blog-single mb-0 bg-transparent p-0 radius-none">
                    <div class="blog-img">
                        <img
                                src="assets/images/enerji-izleme-cozumleri-ile-uretimde-verimlilik.jpg"
                                alt="Enerji izleme çözümleri ile üretimde verimlilik"
                        />
                    </div>

                    <div class="blog-content">
                        <h2 class="blog-title mt-4">Enerji izleme çözümleri ile üretimde verimlilik</h2>

                        <p class="blog-text">
                            Üretim tesislerinde enerjinin nerede, ne kadar ve ne zaman tüketildiğini anlık takip etmek;
                            maliyetleri düşürmenin, arıza ve duruşları azaltmanın ve sürdürülebilirlik hedeflerine
                            yaklaşmanın en pratik yoludur. Enerji izleme çözümleri; sayaçlar, akım/gerilim dönüştürücüler,
                            veri toplayıcılar (gateway), PLC/SCADA entegrasyonu ve raporlama panolarından oluşan bütüncül
                            bir yapıyla çalışır.
                        </p>

                        <h4>Enerji izleme ne sağlar?</h4>
                        <p class="blog-text">
                            <strong>Şeffaflık:</strong> Hat, makine veya bina bazında tüketimi ayrıştırarak “hangi
                            prosesin” maliyeti yükselttiğini ortaya koyar.
                        </p>
                        <p class="blog-text">
                            <strong>Verimlilik:</strong> Pik talep dönemleri, boşta çalışma ve kaçak tüketimler tespit
                            edilerek optimizasyon yapılır.
                        </p>
                        <p class="blog-text">
                            <strong>Kalite ve süreklilik:</strong> Gerilim dalgalanmaları ve harmonikler gibi güç kalitesi
                            sorunları görünür olur; ekipman ömürleri uzar, plansız duruşlar azalır.
                        </p>

                        <h4>İzlenmesi gereken temel parametreler</h4>
                        <p class="blog-text"><strong>Aktif/Reaktif Enerji &amp; Güç Faktörü (cosφ):</strong> Faturalara doğrudan etki eden ana göstergeler.</p>
                        <p class="blog-text"><strong>Anlık Güç ve Talep (kW/kVA):</strong> Pik talep cezalarını önlemek için kritik.</p>
                        <p class="blog-text"><strong>Akım &amp; Gerilim (faz bazlı):</strong> Asimetriler ve dengesiz yüklerin tespiti.</p>
                        <p class="blog-text"><strong>Harmonikler (THD):</strong> Sürücü, robot ve hassas ekipman performansını etkileyen kalite ölçütü.</p>
                        <p class="blog-text"><strong>Çalışma Saatleri &amp; Üretim Verisi:</strong> KWh/ürün ve hat bazlı verimlilik (OEE ile ilişkilendirme).</p>

                        <h4>Uygulama adımları</h4>
                        <p class="blog-text">
                            <strong>1. Keşif ve hedef KPI:</strong> Hangi hat/ekipmanın izleneceği ve hedeflerin (kWh/ürün, pik talep,
                            reaktif oranı vb.) netleştirilmesi.
                        </p>
                        <p class="blog-text">
                            <strong>2. Donanım yerleşimi:</strong> Ana pano, alt dağıtım ve makine girişlerine uygun sensör/sayaç seçimi;
                            güvenli kablolama ve kalibrasyon.
                        </p>
                        <p class="blog-text">
                            <strong>3. Veri toplanması:</strong> Modbus/TCP, Profinet vb. protokollerle PLC/SCADA’ya ve
                            endüstriyel IoT platformuna aktarım.
                        </p>
                        <p class="blog-text">
                            <strong>4. Görselleştirme ve alarm:</strong> Panolar, eğilim grafikleri, tüketim eşikleri ve otomatik uyarılar.
                        </p>
                        <p class="blog-text">
                            <strong>5. İyileştirme döngüsü:</strong> Eylem planları (zaman programı, yük dengeleme, kompanzasyon,
                            bakım planları) ve periyodik gözden geçirme.
                        </p>

                        <h4>Üretime etkisi</h4>
                        <p class="blog-text">
                            Enerji izleme; proses ayarlarının optimize edilmesi, kompanzasyonun doğru işletilmesi ve
                            ekipmanların uygun zamanda devreye alınmasıyla birim ürün başına enerji tüketimini düşürür.
                            Ayrıca kestirimci bakım için anlamlı sinyaller üreterek kalite ve teslimat performansına
                            katkı sağlar.
                        </p>

                        <p class="blog-text">
                            Çözümün tesisinize nasıl uyarlanabileceğini konuşmak için bizimle iletişime geçebilirsiniz.
                            <a href="mailto:info@arkonotomasyon.com.tr" class="text-theme">info@arkonotomasyon.com.tr</a> üzerinden
                            demo talep edebilirsiniz.
                        </p>
                    </div>
                </div>

            </div>
            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    <div class="widget" style="background: #f6f6f6;">
                        <h3 class="widget_title" style="color: black;">Haberler &amp; Blog</h3>

                        <div class="recent-post-wrap">
                            <!-- Post 1 (en yeni) -->
                            <article class="recent-post">
                                <div class="media-img">
                                    <a href="blog-details.html" class="text-inherit" aria-label="Endüstriyel IoT ve sensör trendleri 2025">
                                        <picture>
                                            <img src="assets/images/endustriyel-iot-ve-sensor-trendleri-2025.jpg" alt="Endüstriyel IoT ve sensör trendleri 2025" loading="lazy" decoding="async" width="96" height="72" />
                                        </picture>
                                    </a>
                                </div>
                                <div class="media-body">
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="blog-details.html">Endüstriyel IoT ve sensör trendleri 2025</a>
                                    </h4>
                                </div>
                            </article>

                            <!-- Post 2 -->
                            <article class="recent-post">
                                <div class="media-img">
                                    <a href="blog-details.html" class="text-inherit" aria-label="Panel entegrasyonlarında dikkat edilmesi gerekenler">
                                        <picture>
                                            <img
                                                    src="assets/images/panel-entegrasyonlarinda-dikkat-edilmesi-gerekenler.jpg"
                                                    alt="Panel entegrasyonlarında dikkat edilmesi gerekenler"
                                                    loading="lazy"
                                                    decoding="async"
                                                    width="96"
                                                    height="72"
                                            />
                                        </picture>
                                    </a>
                                </div>
                                <div class="media-body">
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="blog-details.html">Panel entegrasyonlarında dikkat edilmesi gerekenler</a>
                                    </h4>
                                </div>
                            </article>

                            <!-- Post 3 -->
                            <article class="recent-post">
                                <div class="media-img">
                                    <a href="blog-details.html" class="text-inherit" aria-label="Enerji izleme çözümleri ile üretimde verimlilik">
                                        <picture>
                                            <img src="assets/images/enerji-izleme-cozumleri-ile-uretimde-verimlilik.jpg" alt="Enerji izleme çözümleri ile üretimde verimlilik" loading="lazy" decoding="async" width="96" height="72" />
                                        </picture>
                                    </a>
                                </div>
                                <div class="media-body">
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="blog-details.html">Enerji izleme çözümleri ile üretimde verimlilik</a>
                                    </h4>
                                </div>
                            </article>
                        </div>

                        <!-- İsteğe bağlı: Tümü butonu -->
                        <div class="mt-3">
                            <a href="blog.html" class="th-btn style-border2 th-btn-icon w-100">Tüm Yazıları Gör</a>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<?php
include 'partials/footer.php';
?>
<script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
<script src="assets/js/app.min.js"></script>
<script src="assets/js/main.js"></script>
</body>
</html>
