<!DOCTYPE html>
<html class="no-js" lang="tr" dir="ltr">
    <?php
    include 'partials/head.php';
?>
    <body class="">
        <?php
        include 'partials/header.php';
    ?>
        <div class="breadcumb-wrapper background-image" style="background-image: url(assets/images/banner.jpg);">
            <div class="breadcumb-overlay" data-bg-src="assets/img/bg/breadcumb-bg-overlay.png"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcumb-content">
                            <h1 class="breadcumb-title">Entegre PC Yazılımları</h1>
                            <ul class="breadcumb-menu">
                                <li><a href="index.php">Anasayfa</a></li>
                                <li>Çözümler & Sektörler</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="space-top space-extra2-bottom">
            <div class="container">
                <div class="row gx-40">
                    <div class="col-xxl-8 col-lg-7">
                        <div class="page-single mb-40">
                            <div class="page-img mb-25">
                                <img src="assets/img/service/service-details-1-1.jpg" alt="Entegre PC Yazılımları" />
                            </div>
                            <div class="page-content">
                                <h2 class="page-title fw-semibold">Entegre PC Yazılımları</h2>
                                <p class="mb-30">
                                    Üretim hatlarında ve fabrikalarda çalışan makinelerin ve süreçlerin bilgisayar üzerinden yönetilmesini sağlayan yazılım çözümleridir. Bu yazılımlar genellikle endüstriyel PC'ler (IPC) üzerinde çalışır ve
                                    SCADA, HMI, veri toplama, analiz, planlama gibi birçok işlevi aynı platformda birleştirir.
                                </p>
                                <h4 class="fw-semibold mb-25">1. İzleme Fonksiyonu</h4>
                                <ul class="mb-30">
                                    <li>Gerçek zamanlı veri takibi: Sıcaklık, basınç, hız, ürün sayısı, kalite parametreleri gibi veriler anlık izlenir.</li>
                                    <li>Operatör arayüzleri: Grafiksel kullanıcı arayüzleri sayesinde üretim durumu görselleştirilir.</li>
                                    <li>Alarm ve uyarı sistemleri: Arıza veya sapma durumlarında kullanıcı bilgilendirilir.</li>
                                </ul>
                                <h4 class="fw-semibold mb-25">2. Kontrol Fonksiyonu</h4>
                                <ul class="mb-30">
                                    <li>Süreç otomasyonu: Yazılım, makinelere gönderdiği komutlarla üretimi otomatikleştirir.</li>
                                    <li>Uzaktan kontrol: Yetkili kullanıcılar üretim sürecine uzaktan müdahale edebilir.</li>
                                    <li>Proses yönetimi: Üretimin tüm aşamaları yazılım üzerinden yönetilir.</li>
                                </ul>
                                <h4 class="fw-semibold mb-25">3. Optimizasyon Fonksiyonu</h4>
                                <ul class="mb-30">
                                    <li>Verimlilik analizi: Üretim performansı, duruş süreleri ve arızalar değerlendirilir.</li>
                                    <li>Enerji tüketimi izleme: Enerji verileri analiz edilerek verim artırıcı önlemler alınır.</li>
                                    <li>Üretim planlama entegrasyonu: ERP ve MES sistemleriyle entegre çalışır.</li>
                                </ul>
                                <h4 class="fw-semibold mb-25">Kullanım Alanları</h4>
                                <ul class="mb-30">
                                    <li>Otomotiv fabrikaları</li>
                                    <li>Gıda üretim tesisleri</li>
                                    <li>İlaç ve kimya sanayi</li>
                                    <li>Tekstil ve ambalaj sektörleri</li>
                                    <li>Enerji ve altyapı tesisleri</li>
                                </ul>
                                <h4 class="fw-semibold mb-25">Faydaları</h4>
                                <ul>
                                    <li>Tüm üretim süreci tek bir merkezi sistem üzerinden yönetilir.</li>
                                    <li>Daha az arıza ve duruş süresi ile daha yüksek verim.</li>
                                    <li>Üretim kalitesinde ve izlenebilirlikte artış.</li>
                                    <li>Daha hızlı karar alma ve esnek üretim kabiliyeti.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-lg-5">
                        <aside class="sidebar-area">
                            <div class="widget widget_categories">
                                <h3 class="widget_title">Sektörler</h3>
                                <ul>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Entegre PC Yazılımları <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Hareket Kontrol Uygulamaları <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Kamera / Vision Sistemleri <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            PLC / HMI Uygulamaları <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Pano <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Veri Toplama ve Analiz <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Robotik Çözümler <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="endustriyel-cozumler.php">
                                            Makine Emniyeti <span><i class="far fa-arrow-right"></i></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="widget widget_call">
                                <div class="play-btn"><i class="fa-solid fa-phone"></i></div>
                                <h4 class="box-title">Destek Hattı</h4>
                                <a href="tel:+902332221122" class="call">+90 232 222 11 22</a>
                                <a href="contact.html" class="th-btn style4 btn-sm th-btn-icon">Teklif Al</a>
                            </div>
                        </aside>
                    </div>
                </div>
            </div>
        </section>

        <?php include 'partials/footer.php'; ?>

        <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
        <script src="assets/js/app.min.js"></script>
        <script src="assets/js/main.js"></script>
    </body>
</html>
