<!DOCTYPE html>
<html class="no-js" lang="tr" dir="ltr">
<?php
    include 'partials/head.php';
?>
<body class="">
    <?php
        include 'partials/header.php';
    ?>
    <div class="breadcumb-wrapper background-image" style="background-image: url(assets/images/banner.jpg);">
        <div class="breadcumb-overlay" data-bg-src="assets/img/bg/breadcumb-bg-overlay.png"></div>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcumb-content">
                        <h1 class="breadcumb-title">Gıda Endüstrisi</h1>
                        <ul class="breadcumb-menu">
                            <li><a href="index.php">Anasayfa</a></li>
                            <li>Çözümler & Sektörler</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section class="space-top space-extra2-bottom">
        <div class="container">
            <div class="row gx-40">
                <div class="col-xxl-8 col-lg-7">
                    <div class="page-single mb-40">
                        <div class="page-img mb-25">
                            <img src="assets/img/service/service-details-1-1.jpg" alt="Gıda Endüstrisi">
                        </div>
                        <div class="page-content">
                            <h2 class="page-title fw-semibold">Gıda Endüstrisi</h2>
                            <p class="mb-30">
                                Gıda endüstrisi, insan sağlığı ve güvenliği açısından en hassas üretim alanlarından biridir. Bu nedenle hem hijyenik tasarımlar hem de doğru ekipman seçimi hayati önem taşır. Firmamız, gıda üretim hatlarına özel çözümler geliştirerek sektördeki kalite standartlarını desteklemektedir.
                            </p>
                            <p class="mb-50">
                                Hedefimiz, gıda üretiminde maksimum verimlilik, sürekli kalite kontrol ve izlenebilirlik sağlayan entegre sistemler sunmaktır. Paketleme, dolum, konveyör ve proses otomasyonu gibi alanlarda anahtar teslim projeler sunuyoruz.
                            </p>
                            <h4 class="fw-semibold mb-25">Sunduğumuz Çözümler</h4>
                            <p class="mb-30">
                                Gıda sektörüne özel olarak geliştirilmiş çözümlerimizle; temizlik ve sanitasyon uyumluluğu, enerji verimliliği ve operatör güvenliği gibi kritik gereksinimleri karşılıyoruz.
                            </p>
                            <div class="row gy-3">
                                <div class="col-xl-6">
                                    <div class="checklist style5">
                                        <ul>
                                            <li>Hijyenik tasarımlı ekipmanlar</li>
                                            <li>Gıdaya temas eden bölgeler için uygun malzeme kullanımı</li>
                                            <li>Hat üzeri kalite kontrol sistemleri</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="checklist style5">
                                        <ul>
                                            <li>Akıllı proses izleme ve veri kayıt sistemleri</li>
                                            <li>Enerji verimli otomasyon çözümleri</li>
                                            <li>SIP/CIP uyumlu yıkama sistemleri</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <h4 class="fw-semibold mb-25 mt-50">Sürecin İşleyişi</h4>
                            <p class="mb-30">
                                Proje ihtiyacınız belirlendikten sonra teknik ekibimizle birlikte sahada inceleme yapılır. Uygun sistem tasarımı ve proje tekliflendirme adımlarıyla tedarik süreci başlatılır ve montaj ile kurulum tamamlandıktan sonra devreye alma desteği sağlanır.
                            </p>
                            <div class="row gy-40">
                                <div class="col-sm-6 col-xl-4">
                                    <div class="process-card3">
                                        <div class="box-icon"><i class="fal fa-file-lines"></i></div>
                                        <h2 class="box-title">Analiz & Keşif</h2>
                                        <p class="box-text">Yerinde ihtiyaç tespiti ile projeye özgü sistem analizi</p>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-xl-4">
                                    <div class="process-card3">
                                        <div class="box-icon"><i class="fal fa-pen-ruler"></i></div>
                                        <h2 class="box-title">Tasarım & Teklif</h2>
                                        <p class="box-text">Sektör standartlarına uygun çözümler için proje planlaması</p>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-xl-4">
                                    <div class="process-card3">
                                        <div class="box-icon"><i class="fal fa-circle-check"></i></div>
                                        <h2 class="box-title">Kurulum & Devreye Alma</h2>
                                        <p class="box-text">Sistemin montajı ve test süreçleriyle sorunsuz devreye alma</p>
                                    </div>
                                </div>
                            </div>
                            <h4 class="fw-semibold mb-25 mt-50">Avantajlar</h4>
                            <p class="mb-30">
                                Uzman ekip ve çevreci yaklaşımla geliştirdiğimiz sistemler sayesinde gıda üretiminde hijyen, kalite ve verimliliği bir araya getiriyoruz. Uzun ömürlü sistemlerimiz, rekabetçi avantaj sağlar.
                            </p>
                            <div class="row gy-40 align-items-center">
                                <div class="col-xl-6">
                                    <div class="page-img">
                                        <img src="assets/img/service/service-details-1-2.jpg" alt="Gıda Teknolojileri">
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <p class="mt-n2">Tasarımdan montaja, testten teknik desteğe kadar her aşamada yanınızdayız. Şeffaf iletişim ve esnek çözümlerimizle güvenilir iş ortaklığı sunuyoruz.</p>
                                    <div class="checklist style5">
                                        <ul>
                                            <li>Hijyenik tasarıma uygunluk</li>
                                            <li>Enerji ve kaynak tasarrufu</li>
                                            <li>Endüstri 4.0 uyumlu altyapı</li>
                                            <li>Servis ve yedek parça desteği</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-lg-5">
                    <aside class="sidebar-area">
                        <div class="widget widget_categories">
                            <h3 class="widget_title">Sektörler</h3>
                            <ul>
                                <li><a href="#">Gıda Endüstrisi <span><i class="far fa-arrow-right"></i></span></a></li>
                                <li><a href="#">Plastik Üretim <span><i class="far fa-arrow-right"></i></span></a></li>
                                <li><a href="#">Otomotiv <span><i class="far fa-arrow-right"></i></span></a></li>
                                <li><a href="#">Test Teknolojileri <span><i class="far fa-arrow-right"></i></span></a></li>
                                <li><a href="#">Endüstriyel Baskı <span><i class="far fa-arrow-right"></i></span></a></li>
                            </ul>
                        </div>
                        <div class="widget widget_call">
                            <div class="play-btn"><i class="fa-solid fa-phone"></i></div>
                            <h4 class="box-title">Destek Hattı</h4>
                            <a href="tel:+902332221122" class="call">+90 232 222 11 22</a>
                            <a href="contact.html" class="th-btn style4 btn-sm th-btn-icon">Teklif Al</a>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>

    <?php include 'partials/footer.php'; ?>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>
</html>