<!DOCTYPE html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include 'partials/head.php';
?>
<body class="">
<?php
include 'partials/header.php';
?>
<div class="breadcumb-wrapper background-image" style="background-image: url(assets/images/banner.jpg);">
    <div class="breadcumb-overlay" data-bg-src="assets/img/bg/breadcumb-bg-overlay.png"></div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">Akım ve gerilim ölçme teknolojisi</h1>
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Anasayfa</a></li>
                        <li>Ürünlerimiz</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<section class="product-details space-top space-extra-bottom">
    <div class="container">
        <div class="row gx-60">
            <div class="col-lg-4">
                <div class="product-big-img">
                    <div class="img"><img src="assets/images/urun-kapak.png" alt="Product Image"/></div>
                </div>
            </div>
            <div class="col-lg-4 align-self-center">
                <div class="product-about">
                    <h2 class="product-title fw-semibold">Akım ve gerilim ölçme teknolojisi</h2>
                    <p class="text">
                        Akım ve gerilim ölçüm teknolojisi portföyümüz birçok uygulama imkanı sunar: Akım
                        transdüserlerimiz aracılığıyla her bir dalga formundaki doğru ve alternatif akımların yanı sıra,
                        bozuk yapılı alternatif
                        akımları da ölçebilir ve bunları çok sayıda standart analog sinyale dönüştürebilirsiniz. Gerilim
                        transdüserlerimiz farklı sinyal aralıklarındaki DC gerilimleri ve sinüzoidal AC gerilimleri alır
                        ve bunları
                        ayrıca standart analog sinyallere dönüştürür.
                    </p>
                    <div class="mt-2 link-inherit">
                        <p>
                            <strong class="text-title me-3">Stok Durumu:</strong> <span
                                    class="stock in-stock text-theme"><i class="far fa-check-square me-2 ms-1"></i>Stok Sorunuz</span>
                        </p>
                    </div>
                    <div class="actions">
                        <a
                                class="th-btn th-btn--whatsapp"
                                href="https://wa.me/905551112233?text=Merhaba%2C%20teklif%20almak%20istiyorum."
                                target="_blank" rel="noopener"
                        >
                            Whatsapp Teklif İste <i class="fab fa-whatsapp"></i>
                        </a>

                        <a
                                class="th-btn th-btn--mail"
                                href="mailto:info@senindomain.com?subject=Teklif%20Talebi&body=Merhaba%2C%20%C3%BCr%C3%BCn%2Fhizmet%20i%C3%A7in%20teklif%20almak%20istiyorum."
                        >
                            Mail ile Bilgi Al <i class="fas fa-envelope"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <aside class="sidebar-area">
                    <div class="widget" style="background: #f6f6f6;">
                        <h3 class="widget_title" style="color: black">Haberler &amp; Blog</h3>

                        <div class="recent-post-wrap">

                            <!-- Post 1 (en yeni) -->
                            <article class="recent-post">
                                <div class="media-img">
                                    <a href="blog-detay.php" class="text-inherit"
                                       aria-label="Endüstriyel IoT ve sensör trendleri 2025">
                                        <picture>

                                            <img src="assets/images/endustriyel-iot-ve-sensor-trendleri-2025.jpg"
                                                 alt="Endüstriyel IoT ve sensör trendleri 2025"
                                                 loading="lazy" decoding="async" width="96" height="72">
                                        </picture>
                                    </a>
                                </div>
                                <div class="media-body">
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="blog-detay.php">Endüstriyel IoT ve sensör
                                            trendleri 2025</a>
                                    </h4>
                                </div>
                            </article>

                            <!-- Post 2 -->
                            <article class="recent-post">
                                <div class="media-img">
                                    <a href="blog-detay.php" class="text-inherit"
                                       aria-label="Panel entegrasyonlarında dikkat edilmesi gerekenler">
                                        <picture>

                                            <img src="assets/images/panel-entegrasyonlarinda-dikkat-edilmesi-gerekenler.jpg"
                                                 alt="Panel entegrasyonlarında dikkat edilmesi gerekenler"
                                                 loading="lazy" decoding="async" width="96" height="72">
                                        </picture>
                                    </a>
                                </div>
                                <div class="media-body">

                                    <h4 class="post-title">
                                        <a class="text-inherit" href="blog-detay.php">Panel entegrasyonlarında dikkat
                                            edilmesi gerekenler</a>
                                    </h4>
                                </div>
                            </article>

                            <!-- Post 3 -->
                            <article class="recent-post">
                                <div class="media-img">
                                    <a href="blog-detay.php" class="text-inherit"
                                       aria-label="Enerji izleme çözümleri ile üretimde verimlilik">
                                        <picture>

                                            <img src="assets/images/enerji-izleme-cozumleri-ile-uretimde-verimlilik.jpg"
                                                 alt="Enerji izleme çözümleri ile üretimde verimlilik"
                                                 loading="lazy" decoding="async" width="96" height="72">
                                        </picture>
                                    </a>
                                </div>
                                <div class="media-body">

                                    <h4 class="post-title">
                                        <a class="text-inherit" href="blog-detay.php">Enerji izleme çözümleri ile
                                            üretimde verimlilik</a>
                                    </h4>
                                </div>
                            </article>

                        </div>

                        <!-- İsteğe bağlı: Tümü butonu -->
                        <div class="mt-3">
                            <a href="blog.html" class="th-btn style-border2 th-btn-icon w-100">Tüm Yazıları Gör</a>
                        </div>
                    </div>
                </aside>

            </div>
        </div>
        <ul class="nav product-tab-style1 mt-5" id="productTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link th-btn active" id="description-tab" data-bs-toggle="tab" href="#description"
                   role="tab">Ürün Açıklaması</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link th-btn" id="reviews-tab" data-bs-toggle="tab" href="#reviews" role="tab">Teknik
                    Özellikler</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link th-btn" id="reviews-tab" data-bs-toggle="tab" href="#download"
                   role="tab">İndirmeler</a>
            </li>
        </ul>
        <div class="tab-content mt-3" id="productTabContent">
            <!-- Ürün Açıklaması -->
            <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="description-tab">
                <h4>Akım ve gerilim ölçme teknolojisi – Genel Bakış</h4>
                <p>
                    Bu ürün, endüstriyel uygulamalarda yüksek doğrulukta akım ve gerilim takibi yapılmasına olanak
                    tanır. Ölçülen değerler standart analog sinyallere dönüştürülerek PLC, DCS gibi sistemlere entegre
                    edilebilir. Enerji
                    izleme, makine kontrolü, üretim hatları gibi birçok alanda güvenle kullanılabilir.
                </p>
                <p>
                    Bu ürün, endüstriyel uygulamalarda yüksek doğrulukta akım ve gerilim takibi yapılmasına olanak
                    tanır. Ölçülen değerler standart analog sinyallere dönüştürülerek PLC, DCS gibi sistemlere entegre
                    edilebilir. Enerji
                    izleme, makine kontrolü, üretim hatları gibi birçok alanda güvenle kullanılabilir.
                </p>
            </div>

            <!-- Teknik Özellikler -->
            <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                        <tr class="urun-table">
                            <th>Özellik</th>
                            <th>Açıklama</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>Giriş Akımı</td>
                            <td>0...50 A AC / DC</td>
                        </tr>
                        <tr>
                            <td>Giriş Gerilimi</td>
                            <td>0...600 V AC / DC</td>
                        </tr>
                        <tr>
                            <td>Çıkış Sinyali</td>
                            <td>0...10 V / 4...20 mA</td>
                        </tr>
                        <tr>
                            <td>Doğruluk Sınıfı</td>
                            <td>±0.5%</td>
                        </tr>
                        <tr>
                            <td>Besleme Gerilimi</td>
                            <td>24 V DC</td>
                        </tr>
                        <tr>
                            <td>Çalışma Sıcaklığı</td>
                            <td>-10°C ~ +60°C</td>
                        </tr>
                        <tr>
                            <td>Koruma Sınıfı</td>
                            <td>IP20</td>
                        </tr>
                        <tr>
                            <td>Montaj</td>
                            <td>DIN Rayı</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- İndirmeler -->
            <!-- İndirmeler -->
            <div class="tab-pane fade" id="download" role="tabpanel" aria-labelledby="download-tab">
                <h4>İndirmeler</h4>
                <p class="mb-4">Ürüne ait teknik dökümanlara aşağıdan ulaşabilirsiniz:</p>

                <div class="download-list">
                    <div class="download-item d-flex align-items-center justify-content-between mb-3 p-3 border rounded">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-file-earmark-pdf-fill fs-3 text-danger me-3"></i>
                            <div>
                                <div class="fw-bold">Kullanım Kılavuzu (PDF)</div>
                                <small class="text-muted">Ürünün montaj ve kullanım talimatları</small>
                            </div>
                        </div>
                        <a href="/downloads/kullanim-kilavuzu.pdf" class="btn btn-outline-primary btn-sm" download>
                            İndir
                        </a>
                    </div>

                    <div class="download-item d-flex align-items-center justify-content-between mb-3 p-3 border rounded">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-file-earmark-excel-fill fs-3 text-success me-3"></i>
                            <div>
                                <div class="fw-bold">Teknik Özellikler Tablosu (XLSX)</div>
                                <small class="text-muted">Tüm teknik detayların yer aldığı tablo</small>
                            </div>
                        </div>
                        <a href="/downloads/teknik-detaylar.xlsx" class="btn btn-outline-primary btn-sm" download>
                            İndir
                        </a>
                    </div>


                </div>
            </div>

        </div>
    </div>
</section>




<?php
include 'partials/footer.php';
?>
<script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
<script src="assets/js/app.min.js"></script>
<script src="assets/js/main.js"></script>
</body>
</html>
