<!DOCTYPE html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include 'partials/head.php';
?>
<body class="">
<?php
include 'partials/header.php';
?>
<div class="breadcumb-wrapper background-image" style="background-image: url(assets/images/banner.jpg);">
    <div class="breadcumb-overlay" data-bg-src="assets/img/bg/breadcumb-bg-overlay.png"></div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">Akım ve gerilim ölçme teknolojisi</h1>
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Anasayfa</a></li>
                        <li>Ürünlerimiz</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<section class="product-details space-top space-extra-bottom">
    <div class="container">
        <div class="row gx-60">
            <div class="col-lg-6">
                <div class="product-big-img">
                    <div class="img"><img src="assets/images/urun-kapak.png" alt="Product Image"/></div>
                </div>
            </div>
            <div class="col-lg-6 align-self-center">
                <div class="product-about">
                    <h2 class="product-title fw-semibold">Akım ve gerilim ölçme teknolojisi</h2>
                    <p class="text">
                        Akım ve gerilim ölçüm teknolojisi portföyümüz birçok uygulama imkanı sunar: Akım
                        transdüserlerimiz aracılığıyla her bir dalga formundaki doğru ve alternatif akımların yanı sıra,
                        bozuk yapılı alternatif
                        akımları da ölçebilir ve bunları çok sayıda standart analog sinyale dönüştürebilirsiniz. Gerilim
                        transdüserlerimiz farklı sinyal aralıklarındaki DC gerilimleri ve sinüzoidal AC gerilimleri alır
                        ve bunları
                        ayrıca standart analog sinyallere dönüştürür.
                    </p>
                    <div class="mt-2 link-inherit">
                        <p>
                            <strong class="text-title me-3">Stok Durumu:</strong> <span
                                    class="stock in-stock text-theme"><i class="far fa-check-square me-2 ms-1"></i>Stok Sorunuz</span>
                        </p>
                    </div>
                    <div class="actions">
                        <a
                                class="th-btn th-btn--whatsapp"
                                href="https://wa.me/905551112233?text=Merhaba%2C%20teklif%20almak%20istiyorum."
                                target="_blank" rel="noopener"
                        >
                            Whatsapp Teklif İste <i class="fab fa-whatsapp"></i>
                        </a>

                        <a
                                class="th-btn th-btn--mail"
                                href="mailto:info@senindomain.com?subject=Teklif%20Talebi&body=Merhaba%2C%20%C3%BCr%C3%BCn%2Fhizmet%20i%C3%A7in%20teklif%20almak%20istiyorum."
                        >
                            Mail ile Bilgi Al <i class="fas fa-envelope"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <ul class="nav product-tab-style1 mt-5" id="productTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link th-btn active" id="description-tab" data-bs-toggle="tab" href="#description"
                   role="tab">Ürün Açıklaması</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link th-btn" id="reviews-tab" data-bs-toggle="tab" href="#reviews" role="tab">Teknik
                    Özellikler</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link th-btn" id="reviews-tab" data-bs-toggle="tab" href="#download"
                   role="tab">İndirmeler</a>
            </li>
        </ul>
        <div class="tab-content mt-3" id="productTabContent">
            <!-- Ürün Açıklaması -->
            <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="description-tab">
                <h4>Akım ve gerilim ölçme teknolojisi – Genel Bakış</h4>
                <p>
                    Bu ürün, endüstriyel uygulamalarda yüksek doğrulukta akım ve gerilim takibi yapılmasına olanak
                    tanır. Ölçülen değerler standart analog sinyallere dönüştürülerek PLC, DCS gibi sistemlere entegre
                    edilebilir. Enerji
                    izleme, makine kontrolü, üretim hatları gibi birçok alanda güvenle kullanılabilir.
                </p>
                <p>
                    Bu ürün, endüstriyel uygulamalarda yüksek doğrulukta akım ve gerilim takibi yapılmasına olanak
                    tanır. Ölçülen değerler standart analog sinyallere dönüştürülerek PLC, DCS gibi sistemlere entegre
                    edilebilir. Enerji
                    izleme, makine kontrolü, üretim hatları gibi birçok alanda güvenle kullanılabilir.
                </p>
            </div>

            <!-- Teknik Özellikler -->
            <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                        <tr class="urun-table">
                            <th>Özellik</th>
                            <th>Açıklama</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>Giriş Akımı</td>
                            <td>0...50 A AC / DC</td>
                        </tr>
                        <tr>
                            <td>Giriş Gerilimi</td>
                            <td>0...600 V AC / DC</td>
                        </tr>
                        <tr>
                            <td>Çıkış Sinyali</td>
                            <td>0...10 V / 4...20 mA</td>
                        </tr>
                        <tr>
                            <td>Doğruluk Sınıfı</td>
                            <td>±0.5%</td>
                        </tr>
                        <tr>
                            <td>Besleme Gerilimi</td>
                            <td>24 V DC</td>
                        </tr>
                        <tr>
                            <td>Çalışma Sıcaklığı</td>
                            <td>-10°C ~ +60°C</td>
                        </tr>
                        <tr>
                            <td>Koruma Sınıfı</td>
                            <td>IP20</td>
                        </tr>
                        <tr>
                            <td>Montaj</td>
                            <td>DIN Rayı</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- İndirmeler -->
            <!-- İndirmeler -->
            <div class="tab-pane fade" id="download" role="tabpanel" aria-labelledby="download-tab">
                <h4>İndirmeler</h4>
                <p class="mb-4">Ürüne ait teknik dökümanlara aşağıdan ulaşabilirsiniz:</p>

                <div class="download-list">
                    <div class="download-item d-flex align-items-center justify-content-between mb-3 p-3 border rounded">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-file-earmark-pdf-fill fs-3 text-danger me-3"></i>
                            <div>
                                <div class="fw-bold">Kullanım Kılavuzu (PDF)</div>
                                <small class="text-muted">Ürünün montaj ve kullanım talimatları</small>
                            </div>
                        </div>
                        <a href="/downloads/kullanim-kilavuzu.pdf" class="btn btn-outline-primary btn-sm" download>
                            İndir
                        </a>
                    </div>

                    <div class="download-item d-flex align-items-center justify-content-between mb-3 p-3 border rounded">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-file-earmark-excel-fill fs-3 text-success me-3"></i>
                            <div>
                                <div class="fw-bold">Teknik Özellikler Tablosu (XLSX)</div>
                                <small class="text-muted">Tüm teknik detayların yer aldığı tablo</small>
                            </div>
                        </div>
                        <a href="/downloads/teknik-detaylar.xlsx" class="btn btn-outline-primary btn-sm" download>
                            İndir
                        </a>
                    </div>


                </div>
            </div>

        </div>
    </div>
</section>
<section class="overflow-hidden space" id="blog-sec">
    <div class="sec-bg-shape2-3 jump shape-mockup d-xl-block d-none" data-bottom="0%" data-right="4%">
        <img src="assets/img/shape/section_shape_2_3.jpg" alt="img" />
    </div>

    <div class="container">
        <div class="row justify-content-lg-between align-items-center">
            <div class="col-xxl-5 col-xl-6 col-lg-7">
                <div class="title-area">
                    <span class="sub-title">Haberler & Blog</span>
                    <h2 class="sec-title">Son Yazılarımız</h2>
                    <p class="sec-text">
                        Endüstriyel otomasyon, sensör teknolojileri ve enerji izleme üzerine en güncel içeriklerimizi keşfedin.
                    </p>
                </div>
            </div>
            <div class="col-auto">
                <div class="sec-btn">
                    <a href="blog.php" class="th-btn style2 th-btn-icon">Tüm Yazıları Gör</a>
                </div>
            </div>
        </div>

        <div class="slider-area">
            <div
                    class="swiper th-slider has-shadow slider-drag-wrap"
                    id="blogSlider3"
                    data-slider-options='{
          "spaceBetween":24,
          "breakpoints":{
            "0":{"slidesPerView":1},
            "576":{"slidesPerView":1},
            "768":{"slidesPerView":2},
            "992":{"slidesPerView":2},
            "1200":{"slidesPerView":3},
            "1500":{"slidesPerView":3}
          },
          "autoHeight":true
        }'
            >
                <div class="swiper-wrapper">
                    <!-- Kart 1 -->
                    <div class="swiper-slide">
                        <div class="blog-card style3">
                            <div class="blog-img">
                                <img src="assets/images/enerji-izleme-cozumleri-ile-uretimde-verimlilik.jpg" alt="blog image" />
                            </div>
                            <div class="blog-content">
                                <h3 class="box-title">
                                    <a href="blog-detay.php">Enerji izleme çözümleri ile üretimde verimlilik</a>
                                </h3>
                                <a href="blog-detay.php" class="th-btn style-border2 th-btn-icon">Devamını Oku</a>
                            </div>
                        </div>
                    </div>

                    <!-- Kart 2 -->
                    <div class="swiper-slide">
                        <div class="blog-card style3">
                            <div class="blog-img">
                                <img src="assets/images/endustriyel-iot-ve-sensor-trendleri-2025.jpg" alt="blog image" />
                            </div>
                            <div class="blog-content">

                                <h3 class="box-title">
                                    <a href="blog-detay.php">Endüstriyel IoT ve sensör trendleri 2025</a>
                                </h3>
                                <a href="blog-detay.php" class="th-btn style-border2 th-btn-icon">Devamını Oku</a>
                            </div>
                        </div>
                    </div>

                    <!-- Kart 3 -->
                    <div class="swiper-slide">
                        <div class="blog-card style3">
                            <div class="blog-img">
                                <img src="assets/images/akimgerilim-olcumunde-dogruluk-nasil-artirilir.jpg" alt="blog image" />
                            </div>
                            <div class="blog-content">

                                <h3 class="box-title">
                                    <a href="blog-detay.php">Akım/gerilim ölçümünde doğruluk nasıl artırılır?</a>
                                </h3>
                                <a href="blog-detay.php" class="th-btn style-border2 th-btn-icon">Devamını Oku</a>
                            </div>
                        </div>
                    </div>

                    <!-- Kart 4 -->
                    <div class="swiper-slide">
                        <div class="blog-card style3">
                            <div class="blog-img">
                                <img src="assets/images/panel-entegrasyonlarinda-dikkat-edilmesi-gerekenler.jpg" alt="blog image" />
                            </div>
                            <div class="blog-content">

                                <h3 class="box-title">
                                    <a href="blog-detay.php">Panel entegrasyonlarında dikkat edilmesi gerekenler</a>
                                </h3>
                                <a href="blog-detay.php" class="th-btn style-border2 th-btn-icon">Devamını Oku</a>
                            </div>
                        </div>
                    </div>
                </div> <!-- /.swiper-wrapper -->
            </div> <!-- /#blogSlider3 -->
        </div> <!-- /.slider-area -->
    </div>
</section>


<?php
include 'partials/footer.php';
?>
<script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
<script src="assets/js/app.min.js"></script>
<script src="assets/js/main.js"></script>
</body>
</html>
