<!DOCTYPE html>
<html class="no-js" lang="en">
    <?php
  include "partials/head.php"
?>

    <body>
        <?php
  include "partials/header.php"
?>

        <!-- end: Header Area -->

        <main id="primary" class="site-main">
            <!-- start: Breadcrumb Section -->
            <section class="tj-page-header" data-bg-image="assets/images/bg/pheader-bg.webp">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tj-page-header-content text-center">
                                <h1 class="tj-page-title text-anim">Hakkımızda</h1>
                                <div class="tj-page-link wow fadeInUp" data-wow-delay="0.1s">
                                    <span>
                                        <a href="index.html">
                                            <span>Anasayfa</span>
                                        </a>
                                    </span>
                                    <span>/</span>
                                    <span>
                                        <span>Hakkımızda</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Breadcrumb Section -->

            <!-- start: History title Section -->
            <section class="tj-history section-space">
                <div class="container">
                    <div class="row rg-30 justify-content-between">
                        <div class="col-xl-5">
                            <div class="sec-heading mb-0">
                                <span class="sub-title wow fadeInUp" data-wow-delay="0.1s">Biz Kimiz?</span>
                                <h2 class="sec-title text-anim">Renova Motorlu Araçlar’ın <span>hikayesine</span> göz atın.</h2>
                            </div>
                        </div>
                        <div class="col-xl-5">
                            <div class="desc wow fadeInUp" data-wow-delay="0.3s">
                                <p>
                                    2008 yılında kurulan Renova Motorlu Araçlar, otomotiv servis sektöründe güven, kalite ve müşteri memnuniyetini esas alarak faaliyet göstermektedir.
                                </p>
                                <p>
                                    Renault Grubu'nun güvenilir yedek parça markası Motrio’nun Yetkili Servisi olarak, araç sahiplerine en uygun çözümleri sunmak için sürekli gelişiyoruz.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: History title Section -->

            <!-- start: History Section -->
            <section class="tj-history-area section-bottom-space">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="timeline">
                                <div class="timeline-inner wow fadeInUp" data-wow-delay="0.1s">
                                    <div class="date">2008</div>
                                    <div class="content">
                                        <div class="top">
                                            <span>01.</span>
                                            <h4 class="title">Kuruluş ve İlk Yıllar</h4>
                                            <p>Renova, otomotiv servis sektöründe kaliteye dayalı hizmet anlayışı ile İstanbul’da kuruldu. İlk hedefimiz: yerel araç sahiplerine güvenilir bir çözüm ortağı olmak.</p>
                                        </div>
                                        <div class="bottom">
                                            <img src="assets/images/history/history-1.webp" alt="history" />
                                            <img src="assets/images/history/history-2.webp" alt="history" />
                                        </div>
                                    </div>
                                </div>
                                <div class="timeline-inner wow fadeInUp" data-wow-delay="0.3s">
                                    <div class="date">2012</div>
                                    <div class="content">
                                        <div class="top">
                                            <span>02.</span>
                                            <h4 class="title">Büyüme ve Hizmet Alanlarının Genişlemesi</h4>
                                            <p>Yeni servis istasyonlarımız ve uzman teknisyen kadromuz ile müşteri sayımız hızla arttı. Hizmet alanlarımızı mekanik bakım, ECU yazılım ve klima bakımına genişlettik.</p>
                                        </div>
                                        <div class="bottom">
                                            <img src="assets/images/history/history-3.webp" alt="history" />
                                            <img src="assets/images/history/history-4.webp" alt="history" />
                                        </div>
                                    </div>
                                </div>
                                <div class="timeline-inner wow fadeInUp" data-wow-delay="0.5s">
                                    <div class="date">2016</div>
                                    <div class="content">
                                        <div class="top">
                                            <span>03.</span>
                                            <h4 class="title">Motrio Yetkili Servis Unvanı</h4>
                                            <p>Renault Grubu'nun yedek parça markası Motrio ile iş birliğine giderek Yetkili Servis olduk. Bu adım, orijinal yedek parça kullanımı ve kurumsal hizmet anlayışımızı güçlendirdi.</p>
                                        </div>
                                        <div class="bottom">
                                            <img src="assets/images/history/history-5.webp" alt="history" />
                                            <img src="assets/images/history/history-6.webp" alt="history" />
                                        </div>
                                    </div>
                                </div>
                                <div class="timeline-inner wow fadeInUp" data-wow-delay="0.7s">
                                    <div class="date">2020</div>
                                    <div class="content">
                                        <div class="top">
                                            <span>04.</span>
                                            <h4 class="title">RenovaCLUP Sadakat Programı</h4>
                                            <p>Müşterilerimize özel avantajlar sunmak amacıyla RenovaCLUP programını hayata geçirdik. İndirimler, kampanyalar ve dijital bildirimlerle müşteri bağlılığını artırdık.</p>
                                        </div>
                                        <div class="bottom">
                                            <img src="assets/images/history/history-7.webp" alt="history" />
                                            <img src="assets/images/history/history-8.webp" alt="history" />
                                        </div>
                                    </div>
                                </div>
                                <div class="timeline-inner wow fadeInUp" data-wow-delay="0.9s">
                                    <div class="date">2024</div>
                                    <div class="content">
                                        <div class="top">
                                            <span>05.</span>
                                            <h4 class="title">Dijitalleşme ve Gelecek Vizyonu</h4>
                                            <p>Online randevu, müşteri portalları ve otomasyon sistemleri ile servis deneyimini dijitalleştirdik. Gelecekte daha çevreci, akıllı ve hızlı servis deneyimi için yatırımlarımız sürüyor.</p>
                                        </div>
                                        <div class="bottom">
                                            <img src="assets/images/history/history-9.webp" alt="history" />
                                            <img src="assets/images/history/history-1.webp" alt="history" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: History Section -->

         <!-- start: Evolution Section -->
<section class="tj-evolute-area">
   <div class="container-xxl-fluid  p-0 d-none d-xxl-block">
      <div class="row g-0">
         <div class="col-lg-7">
            <div class="tj-evolute">
               <span class="tj-evolute-title mb-30 wow fadeInUp" data-wow-delay="0.1s">
                  <i class="tji-star-2"></i>Motrio Yetkili Servis
               </span>
               <div class="desc mb-60 wow fadeInUp" data-wow-delay="0.3s">
                  Renova Motorlu Araçlar, Renault Grubu çatısı altında faaliyet gösteren <strong>Motrio Yetkili Servisi</strong> olarak sizlere yüksek kaliteli, güvenilir ve garantili hizmet sunmaktadır. 
                  <br><br>
                  Motrio ağı, Renault tarafından onaylanmış, orijinal yedek parça tedariki ve gelişmiş teknik altyapıya sahip servis noktalarından oluşur. 
                  Hem Renault hem de farklı marka araçlara profesyonel bakım ve onarım çözümleri sunar.
                  <br><br>
                  Deneyimli teknisyen kadromuz, Motrio’nun sunduğu teknik eğitimlerle donatılmış olup, aracınıza en uygun çözümleri sunmak için çalışmaktadır. Tüm işlemler Motrio servis standartlarına uygun şekilde gerçekleştirilir.
               </div>
         
            </div>
         </div>
         <div class="col-lg-5">
            <div class="tj-evolute-image hover:shine">
               <img src="assets/images/about/evolute.webp" alt="Motrio Yetkili Servis">
               <div class="about-video-box style-2">
                  <div class="video-box">
                     <a class="circle video-popup" data-autoplay="true" data-vbtype="video" data-maxwidth="1200px"
                        href="https://www.youtube.com/watch?v=GGf1JjSAKP4"><i
                           class="fa-sharp fa-solid fa-play"></i>
                     </a>
                  </div>
                  <span class="sub-title">Videoyu İzle</span>
                  <h5 class="title">Motrio Hizmet Kalitesini Keşfedin</h5>
               </div>
            </div>
         </div>
      </div>
   </div>

<!-- start: Certificates Section -->
<section class="tj-team-area section-space">
   <div class="container">
      <div class="row">
         <div class="col-12">
            <div class="sec-heading text-center">
               <div class="sec-text">
                  <span class="sub-title wow fadeInUp" data-wow-delay="0.1s">Belgelerimiz</span>
                  <h2 class="sec-title text-anim">Yetkili Servis & Kalite Belgeleri</h2>
               </div>
            </div>
         </div>
      </div>
      <div class="swiper tj-team-slider wow fadeInUp" data-wow-delay="0.3s">
         <div class="swiper-wrapper">

            <!-- Belge 1 -->
            <div class="swiper-slide">
               <div class="team-item">
                  <div class="team-images">
                     <a class="venobox" data-gall="gallery01" href="assets/images/certificates/belge-1.webp">
                        <img src="assets/images/certificates/belge-1.webp" alt="Yetki Belgesi 1" />
                     </a>
                  </div>
                  <div class="team-content text-center">
                     <div class="team-text">
                        <h5 class="title">Motrio Yetkili Servis Belgesi</h5>
                        <span class="sub-title">Renault Grubu Onaylı</span>
                     </div>
                  </div>
               </div>
            </div>

            <!-- Belge 2 -->
            <div class="swiper-slide">
               <div class="team-item">
                  <div class="team-images">
                     <a class="venobox" data-gall="gallery01" href="assets/images/certificates/belge-2.webp">
                        <img src="assets/images/certificates/belge-2.webp" alt="Kalite Belgesi" />
                     </a>
                  </div>
                  <div class="team-content text-center">
                     <div class="team-text">
                        <h5 class="title">ISO 9001:2015 Kalite Belgesi</h5>
                        <span class="sub-title">Uluslararası Standart</span>
                     </div>
                  </div>
               </div>
            </div>

            <!-- Belge 3 -->
            <div class="swiper-slide">
               <div class="team-item">
                  <div class="team-images">
                     <a class="venobox" data-gall="gallery01" href="assets/images/certificates/belge-3.webp">
                        <img src="assets/images/certificates/belge-3.webp" alt="Servis Eğitimi Belgesi" />
                     </a>
                  </div>
                  <div class="team-content text-center">
                     <div class="team-text">
                        <h5 class="title">Teknik Eğitim Sertifikası</h5>
                        <span class="sub-title">Motrio Eğitim Programı</span>
                     </div>
                  </div>
               </div>
            </div>

            <!-- Belge 4 -->
            <div class="swiper-slide">
               <div class="team-item">
                  <div class="team-images">
                     <a class="venobox" data-gall="gallery01" href="assets/images/certificates/belge-4.webp">
                        <img src="assets/images/certificates/belge-4.webp" alt="Yetki Belgesi" />
                     </a>
                  </div>
                  <div class="team-content text-center">
                     <div class="team-text">
                        <h5 class="title">Hizmet Yeterlilik Belgesi</h5>
                        <span class="sub-title">TSE Onaylı</span>
                     </div>
                  </div>
               </div>
            </div>

         </div>
         <div class="swiper_pagination service-pagination"></div>
      </div>
   </div>
</section>
<!-- end: Certificates Section -->
<!-- start: Mission & Vision Section -->
<section class="mission-vision-section" style="background-color: #f5f5f5; padding: 60px 0;">
    <div class="container" style="max-width: 1200px; margin: 0 auto;">
        <div style="display: flex; flex-wrap: wrap; justify-content: space-between; gap: 30px;">
            
            <!-- Misyon -->
            <div class="box" style="flex: 1; min-width: 300px; background: #fff; padding: 40px 30px; border-radius: 12px; box-shadow: 0 0 20px rgba(0,0,0,0.05);">
                <div style="margin-bottom: 20px;">
                    <i class="fa-solid fa-bullseye" style="font-size: 28px; color: red;"></i>
                </div>
                <h3 style="margin-bottom: 15px; font-size: 20px; font-weight: 600;">Misyonumuz</h3>
                <p style="color: #555;">
                    Kuruluşumuzdan bugüne tüm paydaşlarımızın memnuniyetini en üst seviyede tutmak için çalışıyoruz.
                    Tüm bu faaliyetlerimizi temel ilkelerimiz doğrultusunda hareket ederek gerçekleştiriyoruz.
                </p>
            </div>

            <!-- Vizyon -->
            <div class="box" style="flex: 1; min-width: 300px; background: #fff; padding: 40px 30px; border-radius: 12px; box-shadow: 0 0 20px rgba(0,0,0,0.05);">
                <div style="margin-bottom: 20px;">
                    <i class="fa-solid fa-bolt" style="font-size: 28px; color: red;"></i>
                </div>
                <h3 style="margin-bottom: 15px; font-size: 20px; font-weight: 600;">Vizyonumuz</h3>
                <p style="color: #555;">
                    Aydınlatma sektöründe ulusal ve uluslararası arenada adından sıkça söz ettiren EAE Aydınlatma;
                    kuruluşundan bu yana çevre dostu üretim anlayışıyla çıktığı bu ışık yolculuğunda kalitesi ile
                    daima fark yaratmayı sürdürmektedir.
                </p>
            </div>

        </div>
    </div>
</section>
<!-- end: Mission & Vision Section -->


<!-- start: RenovaCLUP Concept Section -->
<section class="tj-history section-space">
   <div class="container">
      <div class="row rg-30 justify-content-between">
         <div class="col-xl-12">
            <div class="sec-heading text-center mb-40">
               <span class="sub-title wow fadeInUp" data-wow-delay="0.1s">RenovaCLUP</span>
               <h2 class="sec-title text-anim">
                  RenovaCLUP Konsepti ve Amacı
               </h2>
            </div>
         </div>
         <div class="col-xl-10 offset-xl-1">
            <div class="desc text-center wow fadeInUp" data-wow-delay="0.3s">
               <p>
                  RenovaCLUP, Motrio Yetkili Servis noktalarında sunulan hizmetlerin kalitesini artırmak ve müşterilere ayrıcalıklı bir deneyim sunmak amacıyla oluşturulmuş özel bir sadakat platformudur.
               </p>
               <p>
                  Bu platform sayesinde kullanıcılar araç bakım ve onarım işlemlerinde avantajlı kampanyalardan yararlanabilir, puan biriktirerek ödüller kazanabilir ve servis süreçlerini dijital olarak takip edebilirler.
                  RenovaCLUP, müşteri memnuniyetini ve bağlılığını ön planda tutarak, yenilikçi bir hizmet anlayışı sunar.
               </p>
            </div>
         </div>
      </div>
   </div>
</section>
<!-- end: RenovaCLUP Concept Section -->

        </main>

        <?php
        include 'partials/footer.php'
        ?>

        <!-- JS here -->
        <script src="assets/js/jquery.min.js"></script>
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/appear.min.js"></script>
        <script src="assets/js/gsap.min.js"></script>
        <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
        <script src="assets/js/gsap-scroll-trigger.min.js"></script>
        <script src="assets/js/gsap-split-text.min.js"></script>
        <script src="assets/js/smooth-scroll.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
        <script src="assets/js/odometer.min.js"></script>
        <script src="assets/js/jquery-knob.js"></script>
        <script src="assets/js/swiper.min.js"></script>
        <script src="assets/js/nice-select.js"></script>
        <script src="assets/js/venobox.min.js"></script>
        <script src="assets/js/meanmenu.js"></script>
        <script src="assets/js/main.js"></script>
    </body>
</html>
