<!DOCTYPE html>
<html class="no-js" lang="en">
    <?php
  include "partials/head.php"
?>

    <body>
        <?php
  include "partials/header.php"
?>

        <!-- end: Header Area -->

        <main id="primary" class="site-main">
            <!-- start: Breadcrumb Section -->
            <section class="tj-page-header" data-bg-image="assets/images/bg/pheader-bg.webp">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tj-page-header-content text-center">
                                <h1 class="tj-page-title text-anim">Periyodik Bakım</h1>
                                <div class="tj-page-link wow fadeInUp" data-wow-delay="0.1s">
                                    <span>
                                        <a href="index.html">
                                            <span>Anasayfa</span>
                                        </a>
                                    </span>
                                    <span>/</span>
                                    <span>
                                        <span>Hizmetlerimiz</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Breadcrumb Section -->

                <!-- start: Service Section -->
<section class="tj-service-area section-space">
  <div class="container">
    <div class="row rg-50">
      <div class="col-lg-8">
        <div class="tj-post-wrapper">
          <div class="tj-post-single-post mb-0">
            <div class="tj-post-thumb hover:shine wow fadeInUp" data-wow-delay="0.1s">
              <img src="assets/images/service/tj-service-1.webp" alt="post-image">
            </div>
            <h3 class="tj-post-title text-anim">
              Periyodik Bakım Hizmetleri
            </h3>
            <div class="tj-entry-content">
              <p class="wow fadeInUp" data-wow-delay="0.1s">
                Aracınızın uzun ömürlü ve güvenli bir şekilde çalışabilmesi için düzenli periyodik bakımlar büyük önem taşır. Uzman teknisyen kadromuzla, üretici standartlarına uygun şekilde aracınızın ihtiyacı olan tüm bakım işlemlerini titizlikle gerçekleştiriyoruz.
              </p>
              <p class="wow fadeInUp" data-wow-delay="0.3s">
                Periyodik bakım kapsamında motor yağı ve filtre değişimleri, fren sistemi kontrolleri, sıvı seviyeleri, akü, lastik ve genel araç kontrolleri yapılır. Böylece hem performans artar hem de olası büyük arızaların önüne geçilir.
              </p>

              <div class="tj-check-list">
                <h4 class="text-anim">Hizmet Özeti</h4>
                <p class="wow fadeInUp" data-wow-delay="0.1s">
                  Aracınızın sağlığı için gereken tüm rutin bakımlar profesyonel ekip ve ekipmanla eksiksiz olarak yapılır. Kaliteli yedek parçalar ve şeffaf servis anlayışımızla hizmetinizdeyiz.
                </p>
              </div>

              <div class="service-check-list mt-4 wow fadeInUp" data-wow-delay="0.3s">
                <ul>
                  <li><i class="tji-double-check"></i><span>Motor yağı ve filtre değişimi</span></li>
                  <li><i class="tji-double-check"></i><span>Fren sistemi ve sıvı kontrolleri</span></li>
                  <li><i class="tji-double-check"></i><span>Lastik hava ve diş derinliği kontrolü</span></li>
                  <li><i class="tji-double-check"></i><span>Akü ve elektrik sistemi kontrolü</span></li>
                </ul>
              </div>

              <div class="service-images-wrap">
                <div class="row">
                  <div class="col-sm-6">
                    <div class="image-wrap hover:shine wow fadeInUp" data-wow-delay="0.5s">
                      <img src="assets/images/service/tj-service-3.webp" alt="service-image">
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="image-wrap hover:shine wow fadeInUp" data-wow-delay="0.7s">
                      <img src="assets/images/service/tj-service-4.webp" alt="service-image">
                    </div>
                  </div>
                </div>
              </div>

              <div class="check-list mb-40">
                <h4 class="text-anim">Öne Çıkan Özellikler</h4>
                <p class="wow fadeInUp" data-wow-delay="0.1s">
                  Tüm bakım işlemleri profesyonelce ve zamanında gerçekleştirilir. Aracınızın performansını artırırken yakıt tasarrufu sağlar.
                </p>
                <p class="wow fadeInUp" data-wow-delay="0.3s">
                  Güvenliğiniz için her ayrıntı kontrol edilir. Periyodik bakım sayesinde ani arızaların önüne geçilir.
                </p>
              </div>

              <div class="row rg-30 justify-content-center">
                <div class="col-md-4 col-sm-6">
                  <div class="tj-feature wow fadeInUp" data-wow-delay="0.5s">
                    <div class="tj-feature-icon">
                      <i class="tji-quick"></i>
                    </div>
                    <h5 class="tj-feature-title">Hızlı Servis</h5>
                    <div class="desc">
                      <p>Randevulu sistemle hızlı ve zamanında bakım hizmeti</p>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-sm-6">
                  <div class="tj-feature wow fadeInUp" data-wow-delay="0.7s">
                    <div class="tj-feature-icon">
                      <i class="tji-results"></i>
                    </div>
                    <h5 class="tj-feature-title">Garantili İşçilik</h5>
                    <div class="desc">
                      <p>Kullandığımız her parça ve hizmet garantilidir</p>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-sm-6">
                  <div class="tj-feature wow fadeInUp" data-wow-delay="0.9s">
                    <div class="tj-feature-icon">
                      <i class="tji-personalization"></i>
                    </div>
                    <h5 class="tj-feature-title">Kişiye Özel Takip</h5>
                    <div class="desc">
                      <p>Araç geçmişi kayıt altına alınır, bakım zamanı geldiğinde bilgilendirme yapılır</p>
                    </div>
                  </div>
                </div>
              </div>

              <h4 class="text-anim">Sık Sorulan Sorular</h4>
              <div class="tj-faq mt-30">
                <div class="accordion tj-faq-style" id="accordionExample">
                  <div class="accordion-item wow fadeInUp" data-wow-delay="0.1s">
                    <h2 class="accordion-header active">
                      <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapseOne-1">
                        Periyodik bakım ne sıklıkla yapılmalı?
                      </button>
                    </h2>
                    <div id="collapseOne-1" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p>Genellikle 10.000 – 15.000 km’de bir ya da yılda bir kez önerilir. Aracın markası ve kullanım koşullarına göre değişebilir.</p>
                      </div>
                    </div>
                  </div>
                  <div class="accordion-item wow fadeInUp" data-wow-delay="0.3s">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapseOne-2">
                        Hangi parçalar kontrol edilir?
                      </button>
                    </h2>
                    <div id="collapseOne-2" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p>Yağ, hava, yakıt, polen filtreleri, motor yağı, fren balataları, diskler, akü, sıvılar, lastikler gibi parçalar detaylı kontrol edilir.</p>
                      </div>
                    </div>
                  </div>
                  <div class="accordion-item wow fadeInUp" data-wow-delay="0.5s">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapseOne-3">
                        Servis süresi ne kadar sürer?
                      </button>
                    </h2>
                    <div id="collapseOne-3" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                      <div class="accordion-body">
                        <p>Standart bir periyodik bakım ortalama 1-2 saat içerisinde tamamlanır.</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div> <!-- /.tj-entry-content -->
          </div> <!-- /.tj-post-single-post -->
        </div> <!-- /.tj-post-wrapper -->
      </div> <!-- /.col-lg-8 -->

      <!-- Sidebar -->
      <div class="col-lg-4">
        <aside class="tj-service-sidebar">
          <div class="tj-sidebar-widget wow fadeInUp" data-wow-delay="0.1s">
            <h5 class="tj-sidebar-widget-title">Diğer Hizmetlerimiz</h5>
            <div class="service-category">
              <ul>
                <li><a href="#">Araç Tamiri <i class="tji-angle-right"></i></a></li>
                <li><a class="active" href="#">Periyodik Bakım <i class="tji-angle-right"></i></a></li>
                <li><a href="#">ECU Yazılım ve Arıza Tespiti <i class="tji-angle-right"></i></a></li>
                <li><a href="#">Kaporta ve Boya <i class="tji-angle-right"></i></a></li>
                <li><a href="#">Klima Bakımı <i class="tji-angle-right"></i></a></li>
                <li><a href="#">Lastik & Jant <i class="tji-angle-right"></i></a></li>
              </ul>
            </div>
          </div>

          <!-- CTA -->
          <div class="tj-sidebar-widget wow fadeInUp" data-wow-delay="0.1s">
            <div class="tj-sidebar-cta" data-bg-image="assets/images/blog/widget-cta.webp">
              <div class="content">
                <div class="icon">
                  <img src="assets/img/renova-favicon.svg" alt="image">
                </div>
                <h3>Yardıma mı ihtiyacınız var?<br> Hemen bizimle iletişime geçin</h3>
                <p>
                  Deneyimli ekibimizle aracınız için en doğru çözümleri sunuyoruz.
                </p>
              </div>
              <div class="cta-btn">
                <a href="contact.html" class="tj-primary-btn white-btn">
                  <div class="btn_inner">
                    <div class="btn_icon">
                      <span>
                        <i class="tji-arrow-right"></i>
                        <i class="tji-arrow-right"></i>
                      </span>
                    </div>
                    <div class="btn_text"><span>Bize Ulaşın</span></div>
                  </div>
                </a>
                <img class="shapes move-anim-2" src="assets/images/shapes/carrow.png" alt="shape">
              </div>
            </div>
          </div>
        </aside>
      </div> <!-- /.col-lg-4 -->
    </div> <!-- /.row -->
  </div> <!-- /.container -->
</section>
<!-- end: Service Section -->


        </main>

        <?php
        include 'partials/footer.php'
        ?>

        <!-- JS here -->
        <script src="assets/js/jquery.min.js"></script>
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/appear.min.js"></script>
        <script src="assets/js/gsap.min.js"></script>
        <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
        <script src="assets/js/gsap-scroll-trigger.min.js"></script>
        <script src="assets/js/gsap-split-text.min.js"></script>
        <script src="assets/js/smooth-scroll.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
        <script src="assets/js/odometer.min.js"></script>
        <script src="assets/js/jquery-knob.js"></script>
        <script src="assets/js/swiper.min.js"></script>
        <script src="assets/js/nice-select.js"></script>
        <script src="assets/js/venobox.min.js"></script>
        <script src="assets/js/meanmenu.js"></script>
        <script src="assets/js/main.js"></script>
    </body>
</html>
