<!DOCTYPE html>
<html class="no-js" lang="en">
    <?php include "partials/head.php"; ?>
    <body>
        <?php include "partials/header.php"; ?>

        <main id="primary" class="site-main">
            <!-- start: Breadcrumb Section -->
            <section class="tj-page-header" data-bg-image="assets/images/bg/pheader-bg.webp">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tj-page-header-content text-center">
                                <h1 class="tj-page-title text-anim">Randevu Al</h1>
                                <div class="tj-page-link wow fadeInUp" data-wow-delay="0.1s">
                                    <span>
                                        <a href="index.html"><span>Anasayfa</span></a>
                                    </span>
                                    <span>/</span>
                                    <span><span>Randevu Al</span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Breadcrumb Section -->

            <!-- start: Contact Top Section -->
            <section class="tj-contact-area section-space">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="sec-heading text-center">
                                <span class="sub-title wow fadeInUp" data-wow-delay="0.1s">İLETİŞİM</span>
                                <h2 class="sec-title text-anim">Bizimle İletişime Geçin</h2>
                            </div>
                        </div>
                    </div>
                    <div class="row rg-30">
                        <!-- Email -->
                        <div class="col-xl-3 col-lg-6 col-sm-6">
                            <div class="contact-item style-2 wow fadeInUp" data-wow-delay="0.1s">
                                <div class="contact-icon"><i class="tji-email"></i></div>
                                <h3 class="contact-title">E-Posta</h3>
                                <ul class="contact-list">
                                    <li><a href="mailto:info@renova.com.tr">info@renova.com.tr</a></li>
                                    <li><a href="mailto:destek@renova.com.tr">destek@renova.com.tr</a></li>
                                </ul>
                            </div>
                        </div>

                        <!-- Telefon -->
                        <div class="col-xl-3 col-lg-6 col-sm-6">
                            <div class="contact-item style-2 wow fadeInUp" data-wow-delay="0.3s">
                                <div class="contact-icon"><i class="tji-phone"></i></div>
                                <h3 class="contact-title">Telefon</h3>
                                <ul class="contact-list">
                                    <li><a href="tel:05327969338">0532 796 93 38</a></li>
                                    <li><a href="tel:05327969339">0532 796 93 39</a></li>
                                </ul>
                            </div>
                        </div>

                        <!-- Adres -->
                        <div class="col-xl-3 col-lg-6 col-sm-6">
                            <div class="contact-item style-2 wow fadeInUp" data-wow-delay="0.5s">
                                <div class="contact-icon"><i class="tji-location"></i></div>
                                <h3 class="contact-title">Adresimiz</h3>
                                <p>Fevziçakmak, 10661 Sokak No:48, 42285 Karatay/Konya</p>
                            </div>
                        </div>

                        <!-- WhatsApp -->
                        <div class="col-xl-3 col-lg-6 col-sm-6">
                            <div class="contact-item style-2 wow fadeInUp" data-wow-delay="0.7s">
                                <div class="contact-icon"><i class="tji-chat"></i></div>
                                <h3 class="contact-title">WhatsApp</h3>
                                <ul class="contact-list">
                                    <li><a href="https://wa.me/905327969338" target="_blank">Hemen Yazın</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Çalışma Saatleri ve Sosyal Medya -->
                    <div class="row rg-30 mt-4">
                        <!-- Çalışma Saatleri -->
                        <div class="col-xl-6 col-lg-6 col-sm-12">
                            <div class="contact-item style-2 wow fadeInUp" data-wow-delay="0.1s">
                                <div class="contact-icon"><i class="tji-clock"></i></div>
                                <h3 class="contact-title">Çalışma Saatleri</h3>
                                <ul class="contact-list">
                                    <li>Pazartesi - Cuma: 08:30 – 18:00</li>
                                    <li>Cumartesi: 09:00 – 14:00</li>
                                    <li>Pazar: Kapalı</li>
                                </ul>
                            </div>
                        </div>

                        <!-- Sosyal Medya -->
                        <div class="col-xl-6 col-lg-6 col-sm-12">
  <div class="contact-item style-2 wow fadeInUp" data-wow-delay="0.3s">
    <div class="contact-icon"><img src="assets/img/social-media-2.svg" class="ls-is-cached lazyloaded" alt="social-icon" height="28px"></div>
    <div class="footer-social renova-social-icons">
      <h5 class="title">Bizi Takip Edin:</h5>
      <ul>
        <li>
          <a href="#" class="fb"><i class="fa-brands fa-facebook-f"></i></a>
        </li>
        <li>
          <a href="#" class="ig"><i class="fa-brands fa-instagram"></i></a>
        </li>
        <li>
          <a href="#" class="tw"><i class="fa-brands fa-x-twitter"></i></a>
        </li>
        <li>
          <a href="#" class="li"><i class="fa-brands fa-linkedin-in"></i></a>
        </li>
      </ul>
    </div>
  </div>
</div>

<style>
/* Sadece bu sosyal ikonlar için */
.renova-social-icons ul {
  display: flex;
  gap: 12px;
  padding: 0;
  justify-content: center;

  margin-top: 10px;
  list-style: none;
}

.renova-social-icons ul li a {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 38px;
  height: 38px;
  border-radius: 50%;
  color: white;
  font-size: 16px;
  transition: all 0.3s ease;
}

.renova-social-icons a.fb {
  background-color: #3b5998;
}
.renova-social-icons a.ig {
  background: radial-gradient(circle at 30% 107%, #fdf497 0%, #fdf497 5%, #fd5949 45%, #d6249f 60%, #285AEB 90%);
}
.renova-social-icons a.tw {
  background-color: #000;
}
.renova-social-icons a.li {
  background-color: #0077b5;
}

.renova-social-icons a:hover {
  transform: scale(1.1);
  box-shadow: 0 0 8px rgba(0, 0, 0, 0.1);
}
</style>

                    </div>
                </div>
            </section>
            <!-- end: Contact Top Section -->

            <!-- start: Google Map -->
            <section class="tj-contact-area section-bottom-space">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="google-map wow fadeInUp" data-wow-delay="0.3s">
                                <iframe
                                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3147.13815078691!2d32.5463950767146!3d37.92720290336359!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d08f93d6495027%3A0xfaf7cdbc5913debf!2sRenova%20Renault%20Dacia%20%C3%96zel%20Servis%20-%20MOTRIO%20YETK%C4%B0L%C4%B0%20SERV%C4%B0S%C4%B0!5e0!3m2!1str!2str!4v1752654462555!5m2!1str!2str"
                                    width="100%"
                                    height="400"
                                    style="border: 0;"
                                    allowfullscreen=""
                                    loading="lazy"
                                >
                                </iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Google Map -->
        </main>

        <?php include 'partials/footer.php'; ?>

        <!-- JS Files -->
        <script src="assets/js/jquery.min.js"></script>
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/appear.min.js"></script>
        <script src="assets/js/gsap.min.js"></script>
        <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
        <script src="assets/js/gsap-scroll-trigger.min.js"></script>
        <script src="assets/js/gsap-split-text.min.js"></script>
        <script src="assets/js/smooth-scroll.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
        <script src="assets/js/odometer.min.js"></script>
        <script src="assets/js/jquery-knob.js"></script>
        <script src="assets/js/swiper.min.js"></script>
        <script src="assets/js/nice-select.js"></script>
        <script src="assets/js/venobox.min.js"></script>
        <script src="assets/js/meanmenu.js"></script>
        <script src="assets/js/main.js"></script>
    </body>
</html>
