<!DOCTYPE html>
<html class="no-js" lang="en">
    <?php
  include "partials/head.php"
?>

    <body>
        <?php
  include "partials/header.php"
?>

        <!-- end: Header Area -->

        <main id="primary" class="site-main">
            <!-- start: Slider Section -->
            <section class="tj-hero-slider h7-hero-slider style-1">
                <div class="swiper full-slider-active">
                    <div class="swiper-wrapper">
                        <!-- Slide 1: Yetkili Servis Vurgusu -->
                        <div class="swiper-slide">
                            <div class="tj-slider-section" data-bg-image="assets/images/slider/h7-slider-1.webp">
                                <div class="container">
                                    <div class="row">
                                        <div class="slider-wrapper">
                                            <div class="slider-content">
                                                <span class="sub-title"><img src="./assets/img/motorio-favicon.png" alt="" /> MOTRIO YETKİLİ SERVİS</span>
                                                <h1 class="slider-title">Renault ve Dacia Araçlarınız İçin Güvendesiniz</h1>
                                                <div class="desc">
                                                    <p>Orijinal yedek parça, uzman kadro ve Motrio güvencesiyle aracınız emin ellerde.</p>
                                                </div>
                                                <div class="hero-action">
                                                    <a href="https://www.motrio.com.tr/funnel/shop/renova-motorlu-araclar-san-ve-tic-ltd-sti-8157" class="tj-primary-btn slider-button">
                                                        <div class="btn_inner">
                                                            <div class="btn_icon">
                                                                <span><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
                                                            </div>
                                                            <div class="btn_text"><span>Randevu Al</span></div>
                                                        </div>
                                                    </a>
                                                    <a class="call-btn-style-2 slider-button" href="tel:+90 532 796 93 38">
                                                        <span class="icon"><i class="tji-phone"></i></span>
                                                        <span class="text">+90 532 796 93 38</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Slide 2: Hizmet Çeşitliliği -->
                        <div class="swiper-slide">
                            <div class="tj-slider-section" data-bg-image="assets/images/slider/h7-slider-2.webp">
                                <div class="container">
                                    <div class="row">
                                        <div class="slider-wrapper">
                                            <div class="slider-content">
                                                <span class="sub-title"> TÜM BAKIM VE ONARIM</span>
                                                <h1 class="slider-title">Araç Tamiri, Boya, Yazılım ve Daha Fazlası</h1>
                                                <div class="desc">
                                                    <p>Kaporta, boya, ECU yazılımı, klima bakımı, lastik değişimi ve daha fazlası tek noktada.</p>
                                                </div>
                                                <div class="hero-action">
                                                    <a href="hizmetlerimiz.html" class="tj-primary-btn slider-button">
                                                        <div class="btn_inner">
                                                            <div class="btn_icon">
                                                                <span><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
                                                            </div>
                                                            <div class="btn_text"><span>Hizmetlerimizi İncele</span></div>
                                                        </div>
                                                    </a>
                                                    <a class="call-btn-style-2 slider-button" href="tel:+905327969338">
                                                        <span class="icon"><i class="tji-phone"></i></span>
                                                        <span class="text">+90 532 796 93 38</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Slide 3: RenovaCLUP -->
                        <div class="swiper-slide">
                            <div class="tj-slider-section" data-bg-image="assets/images/slider/h7-slider-1.webp">
                                <div class="container">
                                    <div class="row">
                                        <div class="slider-wrapper">
                                            <div class="slider-content">
                                                <span class="sub-title"><img src="./assets/img/renova-favicon.svg" width="20" alt="" /> RENOVACLUP AVANTAJLARI</span>
                                                <h1 class="slider-title">Sadakat Programına Katıl, Kazanmaya Başla</h1>
                                                <div class="desc">
                                                    <p>Ücretsiz kayıt, özel kampanyalar ve indirim fırsatları için hemen RenovaCLUP’a katıl.</p>
                                                </div>
                                                <div class="hero-action">
                                                    <a href="renovaclup.html" class="tj-primary-btn slider-button">
                                                        <div class="btn_inner">
                                                            <div class="btn_icon">
                                                                <span><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
                                                            </div>
                                                            <div class="btn_text"><span>Detayları Gör</span></div>
                                                        </div>
                                                    </a>
                                                    <a class="call-btn-style-2 slider-button" href="tel:+90 532 796 93 38">
                                                        <span class="icon"><i class="tji-phone"></i></span>
                                                        <span class="text">+90 532 796 93 38</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Navigation buttons -->
                    <div class="tj-navigation">
                        <div class="tj-btn tj-btn-prev">
                            <svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="20"></circle></svg>
                            <svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="20"></circle></svg>
                            <i class="tji-arrow-left"></i>
                        </div>
                        <div class="tj-btn tj-btn-next">
                            <svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="20"></circle></svg>
                            <svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="20"></circle></svg>
                            <i class="tji-arrow-right"></i>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Slider Section -->

            <!-- start: Hizmetlerimiz Bölümü -->
            <section class="tj-feature-section with-shape" id="scroll-hero">
                <div class="tj-feature-section-wrap section-space">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <div class="sec-heading text-center">
                                    <span class="sub-title wow fadeInUp" data-wow-delay="0.1s">HİZMETLERİMİZ</span>
                                    <h2 class="sec-title text-anim">Aracınız İçin Tüm Servis Çözümleri Tek Noktada</h2>
                                    <div class="desc wow fadeInUp" data-wow-delay="0.3s">
                                        <p>Renault ve Dacia araçlarınıza özel Motrio Yetkili Servis hizmetleriyle güvenli ve kaliteli bakım sunuyoruz.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row rg-30">
                            <!-- Araç Tamiri -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">Araç Tamiri</h5>
                                        <div class="desc">
                                            <p>Motor, fren, süspansiyon gibi temel arızaların tamiri uzman teknisyenler tarafından yapılır.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Periyodik Bakım -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">Periyodik Bakım</h5>
                                        <div class="desc">
                                            <p>Yağ değişimi, filtre kontrolü, sıvı seviyeleri ve genel kontroller düzenli olarak yapılır.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- ECU Yazılım / Arıza -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">ECU Yazılım & Arıza</h5>
                                        <div class="desc">
                                            <p>Arıza tespiti, beyin (ECU) yazılım güncellemesi ve optimizasyon hizmeti sağlanır.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Kaporta & Boya -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">Kaporta & Boya</h5>
                                        <div class="desc">
                                            <p>Hasar gören parçaların düzeltme, değişim ve boya işlemleri profesyonelce gerçekleştirilir.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Klima Bakımı -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">Klima Bakımı</h5>
                                        <div class="desc">
                                            <p>Klima gazı dolumu, temizlik ve sistem kontrolleriyle konforlu sürüş sağlar.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Lastik & Jant -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">Lastik & Jant</h5>
                                        <div class="desc">
                                            <p>Mevsimlik lastik değişimi, balans ayarı ve jant tamiri gibi işlemler uygulanır.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Orijinal Yedek Parça -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">Orijinal Yedek Parça</h5>
                                        <div class="desc">
                                            <p>Motrio garantili, Renault ve Dacia uyumlu orijinal yedek parçalarla maksimum güvenlik sunar.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- RenovaCLUP (isteğe bağlı olarak gösterim) -->
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="feature-item hover-bg">
                                    <div class="feature-icon svg-animate">
                                        <svg width="80" height="81" viewBox="0 0 80 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M64 10L77.5 39L64 70.5H35L48.5 39L35 10H14.5L2 39L14.5 70.5H25"
                                                stroke="currentcolor"
                                                class="idsUcHxq_0"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 257.987px, 260px;"
                                            ></path>
                                            <path
                                                d="M32 39.1488L27.9355 48H21.7634L18 39.1488L21.7634 31H27.9355L32 39.1488Z"
                                                stroke="currentcolor"
                                                class="idsUcHxq_1"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 49.7841px, 52px;"
                                            ></path>
                                            <path
                                                d="M54.7559 39.4811L63.9362 39.4361L49.9626 70.6671"
                                                stroke="currentcolor"
                                                class="idsUcHxq_2"
                                                style="opacity: 1; visibility: visible; stroke-dashoffset: 0px; stroke-dasharray: 43.395px, 46px;"
                                            ></path>
                                            <style data-made-with="vivus-instant">
                                                .idsUcHxq_0 {
                                                    stroke-dasharray: 258 260;
                                                    stroke-dashoffset: 259;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 0ms forwards;
                                                }

                                                .idsUcHxq_1 {
                                                    stroke-dasharray: 50 52;
                                                    stroke-dashoffset: 51;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 500ms forwards;
                                                }

                                                .idsUcHxq_2 {
                                                    stroke-dasharray: 44 46;
                                                    stroke-dashoffset: 45;
                                                    animation: idsUcHxq_draw 2000ms ease-in-out 1000ms forwards;
                                                }

                                                @keyframes idsUcHxq_draw {
                                                    100% {
                                                        stroke-dashoffset: 0;
                                                    }
                                                }

                                                @keyframes idsUcHxq_fade {
                                                    0% {
                                                        stroke-opacity: 1;
                                                    }

                                                    94.44444444444444% {
                                                        stroke-opacity: 1;
                                                    }

                                                    100% {
                                                        stroke-opacity: 0;
                                                    }
                                                }
                                            </style>
                                        </svg>
                                    </div>
                                    <div class="feature-content">
                                        <h5 class="title">RenovaCLUP Avantajları</h5>
                                        <div class="desc">
                                            <p>Sadakat programımıza katılarak özel kampanya, indirim ve ayrıcalıklardan yararlanın.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Hizmetlerimiz Bölümü -->

            <!-- start: About Section -->
            <section class="tj-about-section-five h7-about-section section-space">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="about-wrapper-four">
                                <!-- Görsel Alanı -->
                                <div class="about-images-group-three hover:shine wow fadeInUp" data-wow-delay="0.1s">
                                    <img src="assets/img/hakkimizda.jpg" alt="Renova Hakkımızda" />
                                </div>

                                <!-- Metin Alanı -->
                                <div class="about-content-five">
                                    <div class="sec-heading h7-section-heading style-4">
                                        <h2 class="sec-title text-anim">Hakkımızda</h2>
                                    </div>
                                    <div class="desc wow fadeInUp" data-wow-delay="0.7s">
                                        <p>
                                            Renova Motorlu Araçlar olarak, Renault ve Dacia marka araçlara yönelik bakım, onarım ve yedek parça hizmetlerini Motrio güvencesiyle sunuyoruz. Uzman teknisyen kadromuz, orijinal parça kullanımı
                                            ve gelişmiş ekipmanlarla aracınıza en doğru müdahaleyi yapar.
                                        </p>
                                        <p>Müşteri memnuniyetini esas alarak çıktığımız bu yolda, RenovaCLUP sadakat programımız ile hizmetlerimizi daha avantajlı hale getiriyor, sürücülere özel kampanya ve indirimler sunuyoruz.</p>
                                    </div>

                                    <!-- Buton Alanı -->
                                    <div class="about-float-area">
                                        <div class="about-float-area-left wow fadeInUp" data-wow-delay="0.4s">
                                            <div class="btn-area wow fadeInUp" data-wow-delay="0.5s">
                                                <a href="about.html" class="tj-primary-btn hero-button">
                                                    <div class="btn_inner">
                                                        <div class="btn_icon">
                                                            <span>
                                                                <i class="tji-arrow-right"></i>
                                                                <i class="tji-arrow-right"></i>
                                                            </span>
                                                        </div>
                                                        <div class="btn_text">
                                                            <span>Detaylı Bilgi</span>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /Metin Alanı -->
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: About Section -->

            <!-- start: Slider Section -->
            <section class="h8-hero style-1 section-space">
                <div class="tj-slider-section h8-hero-inner" data-bg-image="assets/images/hero/h8-hero-bg.webp">
                    <div class="container">
                        <div class="row">
                            <div class="slider-wrapper h8-hero-wrapper">
                                <div class="slider-content h8-hero-content" style="padding-top: 200px;">
                                    <div class="h8-hero-title-wrapper">
                                        <h1 class="slider-title h8-hero-title hero-text-anim">
                                            <span>RenovaCLUP</span> Avantajlarıyla <br />
                                            Sürüş Keyfini Katlayın!
                                        </h1>

                                        <div class="about-circle h8-hero-circle wow zoomIn" data-wow-delay="1.8s">
                                            <div class="circle-wrap">
                                                <img class="rotate-image" src="assets/images/shapes/h5-about-circle.png" alt="image" />
                                                <span class="logo-icon">
                                                    <img src="assets/img/renova-favicon.svg" alt="RenovaCLUP" />
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="desc h8-hero-desc wow fadeInDown" data-wow-delay="1.2s">
                                        <div class="h8-hero-desc-icon"><i class="tji-arrow-bown"></i></div>
                                        <p>Ücretsiz RenovaCLUP üyeliği ile indirimler, kampanyalar ve sadakat avantajlarından hemen yararlanın.</p>
                                    </div>
                                    <div class="h8-hero-banner d-none d-md-block wow fadeInUp" data-wow-delay="1s"><img src="./assets/images/hero/h8-hero-banner.webp" alt="" /></div>

                                    <div class="h8-hero-banner d-block d-md-none wow fadeInUp" data-wow-delay="2s"><img src="./assets/images/hero/h8-hero-banner-sm.webp" alt="" /></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Slider Section -->

            <!-- start: Müşteri Yorumları -->
            <section class="h8-testimonial section-space">
                <div class="container tj-gap-30">
                    <div class="row">
                        <!-- Sol Başlık Alanı -->
                        <div class="col-12 col-lg-8 col-xl-4">
                            <div class="h8-testimonial-section-heading-wrapper">
                                <div class="sec-heading h8-section-heading h8-testimonial-section-heading style-4">
                                    <span class="sub-title wow fadeInUp" data-wow-delay="0.3s">MÜŞTERİ YORUMLARI</span>
                                    <h2 class="sec-title text-anim">Renova’yı Tercih Edenler Ne Diyor?</h2>
                                </div>

                                <div class="btn-area wow fadeInUp" data-wow-delay="0.3s">
                                    <a href="contact.html" class="tj-primary-btn hero-button">
                                        <div class="btn_inner">
                                            <div class="btn_icon">
                                                <span><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
                                            </div>
                                            <div class="btn_text">
                                                <span>Daha Fazla Yorum</span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Yorumlar Slider (Örnekler) -->
                        <div class="col-12 col-md-6 col-xl-4">
                            <div class="h8-testimonial-wrapper">
                                <div class="swiper swiper-container h8-testimonial-slider h8-testimonial-slider-up">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="testimonial-item h8-testimonial-item">
                                                <div class="testimonial-content">
                                                    <div class="author-rating">
                                                        <div class="star-ratings">
                                                            <div class="fill-ratings" style="width: 100%;"><span>★★★★★</span></div>
                                                        </div>
                                                    </div>
                                                    <div class="desc">
                                                        <p>"Aracımın periyodik bakımını burada yaptırdım. Hem uygun fiyatlı hem de çok ilgililerdi. Tavsiye ederim."</p>
                                                    </div>
                                                </div>
                                                <div class="tj-testimonial-author">
                                                    <div class="author-images">
                                                        <img src="assets/images/testimonial/h6-test-1.webp" alt="Müşteri" />
                                                    </div>
                                                    <div class="author-content">
                                                        <h4 class="author-name">Ali K.</h4>
                                                        <span class="sub-title">Clio Kullanıcısı</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="swiper-slide">
                                            <div class="testimonial-item h8-testimonial-item">
                                                <div class="testimonial-content">
                                                    <div class="author-rating">
                                                        <div class="star-ratings">
                                                            <div class="fill-ratings" style="width: 100%;"><span>★★★★★</span></div>
                                                        </div>
                                                    </div>
                                                    <div class="desc">
                                                        <p>"Kaza sonrası kaporta ve boya işlemlerimi Renova’da yaptırdım. Aracım ilk günkü gibi oldu. Çok memnunum."</p>
                                                    </div>
                                                </div>
                                                <div class="tj-testimonial-author">
                                                    <div class="author-images">
                                                        <img src="assets/images/testimonial/h1-test-2.webp" alt="Müşteri" />
                                                    </div>
                                                    <div class="author-content">
                                                        <h4 class="author-name">Zeynep Y.</h4>
                                                        <span class="sub-title">Megane Kullanıcısı</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- swiper-wrapper -->
                                </div>
                                <!-- swiper -->
                            </div>
                        </div>

                        <!-- Diğer Slider (opsiyonel) -->
                        <div class="col-12 col-md-6 col-xl-4">
                            <div class="h8-testimonial-wrapper">
                                <div class="swiper swiper-container h8-testimonial-slider h8-testimonial-slider-down">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="testimonial-item h8-testimonial-item">
                                                <div class="testimonial-content">
                                                    <div class="author-rating">
                                                        <div class="star-ratings">
                                                            <div class="fill-ratings" style="width: 100%;"><span>★★★★★</span></div>
                                                        </div>
                                                    </div>
                                                    <div class="desc">
                                                        <p>"RenovaCLUP üyesi oldum, klima bakımı indirimi aldım. Sadakat sistemleri gerçekten avantajlı."</p>
                                                    </div>
                                                </div>
                                                <div class="tj-testimonial-author">
                                                    <div class="author-images">
                                                        <img src="assets/images/testimonial/h6-test-1.webp" alt="Müşteri" />
                                                    </div>
                                                    <div class="author-content">
                                                        <h4 class="author-name">Mehmet T.</h4>
                                                        <span class="sub-title">Dacia Sandero</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="swiper-slide">
                                            <div class="testimonial-item h8-testimonial-item">
                                                <div class="testimonial-content">
                                                    <div class="author-rating">
                                                        <div class="star-ratings">
                                                            <div class="fill-ratings" style="width: 100%;"><span>★★★★★</span></div>
                                                        </div>
                                                    </div>
                                                    <div class="desc">
                                                        <p>"Yetkili Motrio servis olması güven verdi. ECU yazılım güncellemesiyle performans farkını hissettim."</p>
                                                    </div>
                                                </div>
                                                <div class="tj-testimonial-author">
                                                    <div class="author-images">
                                                        <img src="assets/images/testimonial/h1-test-2.webp" alt="Müşteri" />
                                                    </div>
                                                    <div class="author-content">
                                                        <h4 class="author-name">Elif D.</h4>
                                                        <span class="sub-title">Taliant Kullanıcısı</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- swiper-wrapper -->
                                </div>
                                <!-- swiper -->
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Müşteri Yorumları -->

            <!-- start: Contact Section -->
            <section class="h9-contact-section" data-bg-image="./assets/images/bg/h9-contact-bg.jpg">
                <div class="container">
                    <div class="row">
                        <div class="col">
                            <div class="h9-contact-wrapper">
                                <div class="sec-heading style-2">
                                    <span class="sub-title wow fadeInUp" data-wow-delay="0.3s">BİZE ULAŞIN</span>
                                    <h2 class="sec-title text-anim">İletişime Geçin veya Ziyaret Edin</h2>
                                    <div class="desc wow fadeInUp" data-wow-delay="0.4s">
                                        Her türlü soru, öneri ya da hizmet talepleriniz için bizimle iletişime geçebilirsiniz.
                                    </div>
                                    <div class="video-btn-wrap wow fadeInUp" data-wow-delay="0.5s">
                                        <a class="video-btn vbox-item" href="tel:05327969338">
                                            <span class="play-btn"><i class="fa-solid fa-phone"></i></span>
                                            <span class="video-text">+90 532 796 93 38</span>
                                        </a>
                                        <a class="video-btn vbox-item" href="milto:info@renova.com">
                                            <span class="play-btn"><i class="tji-email"></i></span>
                                            <span class="video-text">info@renova.com</span>
                                        </a>
                                        <a class="video-btn vbox-item" href="https://maps.app.goo.gl/GSbpEdi7sHcZSSof7">
                                            <span class="play-btn"><i class="fa-solid fa-location-dot"></i></span>
                                            <span class="video-text">Fevziçakmak, 10661 Sokak No:48, 42285 Karatay/Konya</span>
                                        </a>
                                    </div>
                                </div>

                                <!-- Form Alanı -->
                                <div class="h9-contact-form_wrap wow fadeInUp" data-wow-delay="0.3s">
                                    <h3 class="form_title">Mesajınızı Bize İletin</h3>
                                    <div class="form">
                                        <form action="iletisim.php" method="post">
                                            <div class="row gx-3">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <input type="text" name="name" placeholder="Ad Soyad *" required />
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <input type="email" name="email" placeholder="E-posta *" required />
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <input type="tel" name="phone" placeholder="Telefon *" required />
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <input type="text" name="subject" placeholder="Konu (opsiyonel)" />
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <div class="form-group">
                                                        <textarea name="message" placeholder="Mesajınız..."></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-button">
                                                <button type="submit">Gönder <i class="fa-solid fa-paper-plane"></i></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Contact Section -->
            <!-- start: Blog & Duyurular Bölümü -->
<section class="tj-blog-section-four section-space">
   <div class="container">
      <div class="row">
         <div class="col-12">
            <div class="sec-heading style-3">
               <div class="sec-text">
                  <span class="sub-title wow fadeInUp" data-wow-delay="0.1s">// Blog & Duyurular</span>
                  <h2 class="sec-title text-anim">Servisimizden Haberler & Tavsiyeler</h2>
               </div>
               <div class="blog-button wow fadeInUp" data-wow-delay="0.3s">
                  <a href="blog.html" class="tj-primary-btn">
                     <div class="btn_inner">
                        <div class="btn_icon">
                           <span>
                              <i class="tji-arrow-right"></i>
                              <i class="tji-arrow-right"></i>
                           </span>
                        </div>
                        <div class="btn_text">
                           <span>Tümünü Gör</span>
                        </div>
                     </div>
                  </a>
               </div>
            </div>
         </div>
      </div>
      <div class="row rg-30 leftSwipeWrap">

         <!-- Blog / Duyuru 1 -->
         <div class="col-xl-4 col-md-6">
            <div class="blog-style-4 left-swipe">
               <div class="blog-images">
                  <a href="blog-details.html"><img src="assets/images/blog/h2-blog-3.webp" alt="Görsel"></a>
                  <div class="blog-date">
                     <span class="date">15</span>
                     <span class="month">Tem</span>
                  </div>
               </div>
               <div class="blog-content">
                  <h4 class="title under-line">
                     <a href="blog-details.html">RenovaCLUP üyelik sistemi yayında!</a>
                  </h4>
                  <div class="blog-button">
                     <a class="blog-btn text-btn" href="blog-details.html">
                        Devamını Oku <i class="tji-arrow-right"></i>
                     </a>
                  </div>
               </div>
            </div>
         </div>

         <!-- Blog / Duyuru 2 -->
         <div class="col-xl-4 col-md-6">
            <div class="blog-style-4 left-swipe">
               <div class="blog-images">
                  <a href="blog-details.html"><img src="assets/images/blog/h2-blog-2.webp" alt="Görsel"></a>
                  <div class="blog-date">
                     <span class="date">08</span>
                     <span class="month">Tem</span>
                  </div>
               </div>
               <div class="blog-content">
                  <h4 class="title under-line">
                     <a href="blog-details.html">Aracınızı yaz sıcaklarına nasıl hazırlarsınız?</a>
                  </h4>
                  <div class="blog-button">
                     <a class="blog-btn text-btn" href="blog-details.html">
                        Devamını Oku <i class="tji-arrow-right"></i>
                     </a>
                  </div>
               </div>
            </div>
         </div>

         <!-- Blog / Duyuru 3 -->
         <div class="col-xl-4 col-md-6">
            <div class="blog-style-4 left-swipe">
               <div class="blog-images">
                  <a href="blog-details.html"><img src="assets/images/blog/h2-blog-1.webp" alt="Görsel"></a>
                  <div class="blog-date">
                     <span class="date">01</span>
                     <span class="month">Tem</span>
                  </div>
               </div>
               <div class="blog-content">
                  <h4 class="title under-line">
                     <a href="blog-details.html">ECU arızası nedir? Belirtileri ve çözüm yolları</a>
                  </h4>
                  <div class="blog-button">
                     <a class="blog-btn text-btn" href="blog-details.html">
                        Devamını Oku <i class="tji-arrow-right"></i>
                     </a>
                  </div>
               </div>
            </div>
         </div>

      </div>
   </div>
</section>
<!-- end: Blog & Duyurular Bölümü -->

        </main>

        <?php
        include 'partials/footer.php'
        ?>

        <!-- JS here -->
        <script src="assets/js/jquery.min.js"></script>
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/appear.min.js"></script>
        <script src="assets/js/gsap.min.js"></script>
        <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
        <script src="assets/js/gsap-scroll-trigger.min.js"></script>
        <script src="assets/js/gsap-split-text.min.js"></script>
        <script src="assets/js/smooth-scroll.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
        <script src="assets/js/odometer.min.js"></script>
        <script src="assets/js/jquery-knob.js"></script>
        <script src="assets/js/swiper.min.js"></script>
        <script src="assets/js/nice-select.js"></script>
        <script src="assets/js/venobox.min.js"></script>
        <script src="assets/js/meanmenu.js"></script>
        <script src="assets/js/main.js"></script>
    </body>
</html>
