<!DOCTYPE html>
<html class="no-js" lang="en">
    <?php
  include "partials/head.php"
?>

    <body>
        <?php
  include "partials/header.php"
?>

        <!-- end: Header Area -->

        <main id="primary" class="site-main">
            <!-- start: Breadcrumb Section -->
            <section class="tj-page-header" data-bg-image="assets/images/bg/pheader-bg.webp">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tj-page-header-content text-center">
                                <h1 class="tj-page-title text-anim">Randevu Al</h1>
                                <div class="tj-page-link wow fadeInUp" data-wow-delay="0.1s">
                                    <span>
                                        <a href="index.html">
                                            <span>Anasayfa</span>
                                        </a>
                                    </span>
                                    <span>/</span>
                                    <span>
                                        <span>Randevu Al</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- end: Breadcrumb Section -->

            <!-- start: Randevu CTA Section -->
            <section class="randevu-cta-section">
      
                <div class="randevu-container">

                    <!-- Features Grid -->
                    <div class="randevu-features-grid">
                        <div class="randevu-feature-card">
                            <div class="randevu-feature-icon">🏆</div>
                            <h3 class="randevu-feature-title">Yetkili Servis</h3>
                            <p class="randevu-feature-description">
                                Renault ve Dacia'nın resmi yetkili servisi olarak fabrika standartlarında hizmet sunuyoruz.
                            </p>
                            <div class="randevu-feature-highlight">Resmi Yetkilendirme</div>
                        </div>
                        
                        <div class="randevu-feature-card">
                            <div class="randevu-feature-icon">🛡️</div>
                            <h3 class="randevu-feature-title">Güven & Kalite</h3>
                            <p class="randevu-feature-description">
                                Uzman teknisyenlerimiz ve modern ekipmanlarımızla aracınız güvenli ellerde.
                            </p>
                            <div class="randevu-feature-highlight">Kalite Garantisi</div>
                        </div>
                        
                        <div class="randevu-feature-card">
                            <div class="randevu-feature-icon">⚙️</div>
                            <h3 class="randevu-feature-title">Orijinal Yedek Parça</h3>
                            <p class="randevu-feature-description">
                                Sadece orijinal ve onaylı yedek parçalar kullanarak aracınızın performansını koruyoruz.
                            </p>
                            <div class="randevu-feature-highlight">Orijinal Parça</div>
                        </div>
                    </div>

                    <!-- CTA Container -->
                    <div class="randevu-cta-container">
                        <h2 class="randevu-cta-title">Hemen Randevu Alın</h2>
                        <p class="randevu-cta-subtitle">
                            Motrio randevu sistemi üzerinden kolayca randevu oluşturun
                        </p>
                        
                        <a href="randevu-al.php" class="tj-primary-btn header_btn d-none d-xl-flex">
                                <div class="btn_inner">
                                    <div class="btn_icon">
                                        <span><i class="tji-arrow-right"></i><i class="tji-arrow-right"></i></span>
                                    </div>
                                    <div class="btn_text"><span>Randevu Al</span></div>
                                </div>
                            </a>
                        
                    </div>
                </div>
            </section>
            <!-- end: Randevu CTA Section -->

        </main>

        <?php
        include 'partials/footer.php'
        ?>

        <!-- JS here -->
        <script src="assets/js/jquery.min.js"></script>
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/appear.min.js"></script>
        <script src="assets/js/gsap.min.js"></script>
        <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
        <script src="assets/js/gsap-scroll-trigger.min.js"></script>
        <script src="assets/js/gsap-split-text.min.js"></script>
        <script src="assets/js/smooth-scroll.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
        <script src="assets/js/odometer.min.js"></script>
        <script src="assets/js/jquery-knob.js"></script>
        <script src="assets/js/swiper.min.js"></script>
        <script src="assets/js/nice-select.js"></script>
        <script src="assets/js/venobox.min.js"></script>
        <script src="assets/js/meanmenu.js"></script>
        <script src="assets/js/main.js"></script>
        
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const randevuBtn = document.getElementById('randevu-motrio-btn');
                
                if (randevuBtn) {
                    randevuBtn.addEventListener('click', function(e) {
                        e.preventDefault();
                        
                        // Basit buton feedback
                        this.style.opacity = '0.8';
                        this.innerHTML = 'Yönlendiriliyor...';
                        
                        setTimeout(() => {
                            // Motrio randevu sistemi linki - buraya gerçek linki ekleyin
                            window.open('https://motrio.com.tr/randevu', '_blank');
                            
                            // Buton sıfırlama
                            this.style.opacity = '1';
                            this.innerHTML = 'Randevu Al';
                        }, 800);
                    });
                }
            });
        </script>
    </body>
</html>