/**
/**
Core script to handle the entire theme and core functions
**/
var Indiro = function () {
	'use strict';

	var screenWidth = $(window).width();

	var homeSearch = function () {
		/* top search in header on click function */
		var quikSearch = jQuery("#quik-search-btn");
		var quikSearchRemove = jQuery("#quik-search-remove");

		quikSearch.on('click', function () {
			jQuery('.dz-quik-search').fadeIn(500);
			jQuery('.dz-quik-search').addClass('On');
		});

		quikSearchRemove.on('click', function () {
			jQuery('.dz-quik-search').fadeOut(500);
			jQuery('.dz-quik-search').removeClass('On');
		});
		/* top search in header on click function End*/
	}

	/* One Page Layout ============ */
	var onePageLayout = function () {
		var headerHeight = parseInt($('.onepage').css('height'), 10);

		$(".scroll").unbind().on('click', function (event) {
			event.preventDefault();

			if (this.hash !== "") {
				var hash = this.hash;
				var seactionPosition = $(hash).offset().top;
				var headerHeight = parseInt($('.onepage').css('height'), 10);


				$('body').scrollspy({ target: ".navbar", offset: headerHeight + 2 });

				var scrollTopPosition = seactionPosition - (headerHeight);

				$('html, body').animate({
					scrollTop: scrollTopPosition
				}, 800, function () {

				});
			}
		});
		$('body').scrollspy({ target: ".navbar", offset: headerHeight + 2 });
	}

	/* Header Height ============ */
	var handleResizeElement = function () {
		var headerTop = 0;
		var headerNav = 0;

		$('.header .sticky-header').removeClass('is-fixed');
		$('.header').removeAttr('style');

		if (jQuery('.header .top-bar').length > 0 && screenWidth > 991) {
			headerTop = parseInt($('.header .top-bar').outerHeight());
		}

		if (jQuery('.header').length > 0) {
			headerNav = parseInt($('.header').height());
			headerNav = (headerNav == 0) ? parseInt($('.header .main-bar').outerHeight()) : headerNav;
		}

		var headerHeight = headerNav + headerTop;

		jQuery('.header').css('height', headerHeight);
	}

	var handleResizeElementOnResize = function () {
		var headerTop = 0;
		var headerNav = 0;

		$('.header .sticky-header').removeClass('is-fixed');
		$('.header').removeAttr('style');


		setTimeout(function () {

			if (jQuery('.header .top-bar').length > 0 && screenWidth > 991) {
				headerTop = parseInt($('.header .top-bar').outerHeight());
			}

			if (jQuery('.header').length > 0) {
				headerNav = parseInt($('.header').height());
				headerNav = (headerNav == 0) ? parseInt($('.header .main-bar').outerHeight()) : headerNav;
			}

			var headerHeight = headerNav + headerTop;

			jQuery('.header').css('height', headerHeight);

		}, 500);
	}

	/* Load File ============ */
	var dzTheme = function () {

		if (screenWidth <= 991) {
			jQuery('.navbar-nav > li > a, .sub-menu > li > a').unbind().on('click', function (e) {
				if (jQuery(this).parent().hasClass('open')) {
					jQuery(this).parent().removeClass('open');
				}
				else {
					jQuery(this).parent().parent().find('li').removeClass('open');
					jQuery(this).parent().addClass('open');
				}
			});
		}
		jQuery('.full-sidenav .navbar-nav > li > a').next('.sub-menu,.mega-menu').slideUp();
		jQuery('.full-sidenav .sub-menu > li > a').next('.sub-menu').slideUp();

		jQuery('.full-sidenav .navbar-nav > li > a, .full-sidenav .sub-menu > li > a').unbind().on('click', function (e) {
			if (jQuery(this).hasClass('dz-open')) {

				jQuery(this).removeClass('dz-open');
				jQuery(this).parent('li').children('.sub-menu,.mega-menu').slideUp();
			} else {
				jQuery(this).addClass('dz-open');

				if (jQuery(this).parent('li').children('.sub-menu,.mega-menu').length > 0) {
					e.preventDefault();
					jQuery(this).next('.sub-menu,.mega-menu').slideDown();
					jQuery(this).parent('li').siblings('li').children('.sub-menu,.mega-menu').slideUp();
				} else {
					jQuery(this).next('.sub-menu,.mega-menu').slideUp();
				}
			}
		});
	}

	var handleSidebarMenu = function () {
		jQuery('.menu-btn').on('click', function () {
			jQuery(this).toggleClass('open');
			jQuery('.full-sidenav, .main-bar').toggleClass('show');
		});
		jQuery('.header.style-2 .menu-btn').on('click', function () {

			//for nav hidden
			if ($(this).hasClass('open')) {
				jQuery('.header.style-2 .header-nav').css({ "visibility": "hidden", "opacity": "0" });
			} else {
				jQuery('.header.style-2 .header-nav').css({ "visibility": "visible", "opacity": "1" });
			}
		});
		jQuery('.menu-close').on('click', function () {
			jQuery('.contact-sidebar').removeClass('active');
			jQuery('.menu-btn').removeClass('open');
		});
	}

	/* Magnific Popup ============ */
	var MagnificPopup = function () {

		if (jQuery('.mfp-gallery').length > 0) {
			/* magnificPopup function */
			jQuery('.mfp-gallery').magnificPopup({
				delegate: '.mfp-link',
				type: 'image',
				tLoading: 'Loading image #%curr%...',
				mainClass: 'mfp-img-mobile',
				gallery: {
					enabled: true,
					navigateByImgClick: true,
					preload: [0, 1] // Will preload 0 - before current, and 1 after the current image
				},
				image: {
					tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
					titleSrc: function (item) {
						return item.el.attr('title') + '<small></small>';
					}
				}
			});
			/* magnificPopup function end */
		}

		if (jQuery('.mfp-video').length > 0) {
			/* magnificPopup for Play video function */
			jQuery('.mfp-video').magnificPopup({
				type: 'iframe',
				iframe: {
					markup: '<div class="mfp-iframe-scaler">' +
						'<div class="mfp-close"></div>' +
						'<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>' +
						'<div class="mfp-title">Some caption</div>' +
						'</div>'
				},
				callbacks: {
					markupParse: function (template, values, item) {
						values.title = item.el.attr('title');
					}
				}
			});

		}

		if (jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps').length > 0) {
			/* magnificPopup for Play video function end */
			$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
				disableOn: 700,
				type: 'iframe',
				mainClass: 'mfp-fade',
				removalDelay: 160,
				preloader: false,

				fixedContentPos: true
			});
		}
	}

	/* Scroll To Top ============ */
	var scrollTop = function () {
		var scrollTop = jQuery("button.scroltop");

		/* page scroll top on click function */
		scrollTop.on('click', function () {
			jQuery("html, body").animate({
				scrollTop: 0
			}, 1000);
			return false;
		})

		jQuery(window).bind("scroll", function () {
			var scroll = jQuery(window).scrollTop();
			if (scroll > 900) {
				jQuery("button.scroltop").fadeIn(1000);
			} else {
				jQuery("button.scroltop").fadeOut(1000);
			}
		});
		/* page scroll top on click function end*/
	}

	/* Header Fixed ============ */
	var headerFix = function () {
		/* Main navigation fixed on top  when scroll down function custom */
		jQuery(window).on('scroll', function () {
			if (jQuery('.sticky-header').length > 0) {
				var menu = jQuery('.sticky-header');
				if ($(window).scrollTop() > menu.offset().top) {
					menu.addClass('is-fixed');
					$('.site-header .container > .logo-header .logo').attr('src', 'images/logo.png');
					$('.site-header .container > .logo-header .logo-2').attr('src', 'images/logo-2.png');
					$('.site-header .container > .logo-header .logo-3').attr('src', 'images/logo-3.png');
				} else {
					menu.removeClass('is-fixed');
					$('.site-header .container > .logo-header .logo, .site-header .container > .logo-header .logo-2, .site-header .container > .logo-header .logo-3').attr('src', 'images/logo-white.png')
				}
			}
		});
		/* Main navigation fixed on top  when scroll down function custom end*/
	}

	/* Masonry Box ============ */
	var masonryBox = function () {
		/* masonry by  = bootstrap-select.min.js */
		if (jQuery('#masonry, .masonry').length > 0) {
			var self = jQuery("#masonry, .masonry");

			if (jQuery('.card-container').length > 0) {
				var gutterEnable = self.data('gutter');

				var gutter = (self.data('gutter') === undefined) ? 0 : self.data('gutter');
				gutter = parseInt(gutter);


				var columnWidthValue = (self.attr('data-column-width') === undefined) ? '' : self.attr('data-column-width');
				if (columnWidthValue != '') { columnWidthValue = parseInt(columnWidthValue); }

				self.imagesLoaded(function () {
					self.masonry({
						//gutter: gutter,
						//columnWidth:columnWidthValue, 
						gutterWidth: 15,
						isAnimated: true,
						itemSelector: ".card-container",
						//percentPosition: true
					});

				});
			}
		}
		if (jQuery('.filters').length) {
			jQuery(".filters li:first").addClass('active');

			jQuery(".filters").on("click", "li", function () {
				jQuery('.filters li').removeClass('active');
				jQuery(this).addClass('active');

				var filterValue = $(this).attr("data-filter");
				self.isotope({ filter: filterValue });
			});
		}
		/* masonry by  = bootstrap-select.min.js end */
	}
	
	/* Select Picker ============ */
	var handleSelectpicker = function(){
		if(jQuery('.default-select').length > 0 && jQuery.isFunction($.fn.selectpicker) ){
			jQuery('.default-select').selectpicker();
		}
	}
	
	/* Counter Number ============ */
	var counter = function () {
		if (jQuery('.counter').length) {
			jQuery('.counter').counterUp({
				delay: 10,
				time: 3000
			});
		}
	}

	/* Video Popup ============ */
	var handleVideo = function () {
		/* Video responsive function */
		jQuery('iframe[src*="youtube.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');
		jQuery('iframe[src*="vimeo.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');
		/* Video responsive function end */
	}

	/* Gallery Filter ============ */
	var handleFilterMasonary = function () {
		/* gallery filter activation = jquery.mixitup.min.js */
		if (jQuery('#image-gallery-mix').length) {
			jQuery('.gallery-filter').find('li').each(function () {
				$(this).addClass('filter');
			});
			jQuery('#image-gallery-mix').mixItUp();
		};
		if (jQuery('.gallery-filter.masonary').length) {
			jQuery('.gallery-filter.masonary').on('click', 'span', function () {
				var selector = $(this).parent().attr('data-filter');
				jQuery('.gallery-filter.masonary span').parent().removeClass('active');
				jQuery(this).parent().addClass('active');
				jQuery('#image-gallery-isotope').isotope({ filter: selector });
				return false;
			});
		}
		/* gallery filter activation = jquery.mixitup.min.js */
	}

	/* Resizebanner ============ */
	var handleBannerResize = function () {
		$(".full-height").css("height", $(window).height());
	}

	/* BGEFFECT ============ */
	var reposition = function () {
		var modal = jQuery(this),
			dialog = modal.find('.modal-dialog');
		modal.css('display', 'block');

		/* Dividing by two centers the modal exactly, but dividing by three 
		 or four works better for larger screens.  */
		dialog.css("margin-top", Math.max(0, (jQuery(window).height() - dialog.height()) / 2));
	}

	var handelResize = function () {
		/* Reposition when the window is resized */
		jQuery(window).on('resize', function () {
			jQuery('.modal:visible').each(reposition);
		});
	}

	/* Countdown ============ */
	var handleCountDown = function (WebsiteLaunchDate) {
		/* Time Countr Down Js */
		if ($(".countdown").length) {
			$('.countdown').countdown({ date: WebsiteLaunchDate + ' 23:5' }, function () {
				$('.countdown').text('we are live');
			});
		}
		/* Time Countr Down Js End */
	}

	/* Website Launch Date */
	var WebsiteLaunchDate = new Date();
	var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	WebsiteLaunchDate.setMonth(WebsiteLaunchDate.getMonth() + 1);
	WebsiteLaunchDate = WebsiteLaunchDate.getDate() + " " + monthNames[WebsiteLaunchDate.getMonth()] + " " + WebsiteLaunchDate.getFullYear();
	/* Website Launch Date END */

	/* Light Gallery ============ */
	var lightGallery = function () {
		if (($('#lightgallery, .lightgallery').length > 0)) {
			$('#lightgallery, .lightgallery').lightGallery({
				selector: '.lightimg',
				loop: true,
				download: false,
				thumbnail: true,
				share: false,
				exThumbImage: 'data-exthumbimage'
			});
		}
	}

	var boxHover = function () {
		jQuery('.box-hover').on('mouseenter', function () {
			var selector = jQuery(this).parent().parent();
			selector.find('.box-hover').removeClass('active');
			jQuery(this).addClass('active');
		});
	}

	
	/* WOW ANIMATION ============ */
	var wow_animation = function () {
		if ($('.wow').length > 0) {
			var wow = new WOW(
				{
					boxClass: 'wow',      // animated element css class (default is wow)
					animateClass: 'animated', // animation css class (default is animated)
					offset: 0,          // distance to the element when triggering the animation (default is 0)
					mobile: false       // trigger animations on mobile devices (true is default)
				});
			wow.init();
		}
	}

	var handleSvgRadiaChart = function(){
		// Remove svg.radial-progress .complete inline styling
		$('svg.radial-progress').each(function( index, value ) { 
			$(this).find($('circle.complete')).removeAttr( 'style' );
		});

		// Activate progress animation on scroll
		$(window).scroll(function(){
			$('svg.radial-progress').each(function( index, value ) { 
				// If svg.radial-progress is approximately 25% vertically into the window when scrolling from the top or the bottom
				if ( 
					$(window).scrollTop() > $(this).offset().top - ($(window).height() * 0.75) &&
					$(window).scrollTop() < $(this).offset().top + $(this).height() - ($(window).height() * 0.25)
				) {
					// Get percentage of progress
					var percent = $(value).data('percentage');
					// Get radius of the svg's circle.complete
					var radius = $(this).find($('circle.complete')).attr('r');
					// Get circumference (2Ï€r)
					var circumference = 2 * Math.PI * radius;
					// Get stroke-dashoffset value based on the percentage of the circumference
					var strokeDashOffset = circumference - ((percent * circumference) / 100);
					// Transition progress for 1.25 seconds
					$(this).find($('circle.complete')).animate({'stroke-dashoffset': strokeDashOffset}, 1250);
				}
			});
		}).trigger('scroll');
	}


	var handleCurrentActive = function () {
		for (var nk = window.location,
			o = $("ul.navbar a").filter(function () {

				return this.href == nk;

			})
				.addClass("active")
				.parent()
				.addClass("active"); ;) {

			if (!o.is("li")) break;

			o = o.parent()
				.addClass("show")
				.parent('li')
				.addClass("active");
		}
	}

	var handleImageTooltip = function () {
		$('.image-tooltip-effect').hover(function () {
			var title = $(this).find('.title').text();
			var subTitle = $(this).find('.sub-title').text();
			$(this).data('tipText', title);
			$('body').append("<div class='image-tooltip'>" + "<h4 class='title'>" + title + "</h4>" + "<h6 class='sub-title'>" + subTitle + "</h6>" + "</div>");
			var imageTooltipWidth = $(this).find('.dz-info').width() + 40;
			$('.image-tooltip').animate({ width: imageTooltipWidth }, 500, "linear");
		}, function () {
			// Hover out code
			$(this).find('span', $(this).data('tipText'));
			$('.image-tooltip').remove();
		}).mousemove(function (e) {
			var mousex = e.pageX + 20; //Get X coordinates
			var mousey = e.pageY + 10; //Get Y coordinates
			$('.image-tooltip').css({ top: mousey, left: mousex })
			if (mousex + $('.image-tooltip').width() + 60 > screen.width) {
				$('.image-tooltip').css({ top: mousey, left: mousex - $('.image-tooltip').width() - 60 })
			}
		});
	}

	/* Range ============ */
	var priceslider = function () {
		if ($(".price-slide").length > 0) {
			$("#slider-range").slider({
				range: true,
				min: 300,
				max: 4000,
				values: [0, 5000],
				slide: function (event, ui) {
					var min = ui.values[0],
						max = ui.values[1];
					$('#' + this.id).next().val("$" + min + " - $" + max);
				}
			});
		}
	}

	/* handle Bootstrap Touch Spin ============ */
	var handleBootstrapTouchSpin = function () {
		if ($("input[name='demo_vertical2']").length > 0) {
			jQuery("input[name='demo_vertical2']").TouchSpin({
				verticalbuttons: true,
				verticalupclass: 'ti-plus',
				verticaldownclass: 'ti-minus'
			});
		}
		if ($(".quantity-input").length > 0) {
			jQuery(".quantity-input").TouchSpin({
				verticalbuttons: true,
				verticalupclass: 'ti-plus',
				verticaldownclass: 'ti-minus'
			});
		}
	}

	var bsSelect = function () {
		if (jQuery.isFunction($.fn.selectpicker)) {
			$('.default-select').selectpicker();
		}
	}

	var handleFinalCountDown = function(){
		var launchDate = jQuery('.countdown-timer').data('date');
		
		if(launchDate != undefined && launchDate != '')
		{
			WebsiteLaunchDate = launchDate;
		}

		if(jQuery('.countdown-timer').length > 0 )
		{
			var startTime = new Date(); // Put your website start time here
			startTime = startTime.getTime();
			
			var currentTime = new Date();
			currentTime = currentTime.getTime();
			
			var endTime = new Date(WebsiteLaunchDate); // Put your website end time here			
			endTime = endTime.getTime();		
			
			$('.countdown-timer').final_countdown({
				
				'start': (startTime/1000),
				'end': (endTime/1000), 
				'now': (currentTime/1000), 
				selectors: {
					value_seconds:'.clock-seconds .val',
					canvas_seconds:'canvas-seconds',
					value_minutes:'.clock-minutes .val',
					canvas_minutes:'canvas-minutes',
					value_hours:'.clock-hours .val',
					canvas_hours:'canvas-hours',
					value_days:'.clock-days .val',
					canvas_days:'canvas-days'
				},
				seconds: {
					borderColor:$('.type-seconds').attr('data-border-color'),
					borderWidth:'5',
				},
				minutes: {
					borderColor:$('.type-minutes').attr('data-border-color'),
					borderWidth:'5'
				},
				hours: {
					borderColor:$('.type-hours').attr('data-border-color'),
					borderWidth:'5'
				},
				days: {
					borderColor:$('.type-days').attr('data-border-color'),
					borderWidth:'5'
				}
			});
		}
	}

	var handleHeaderTabs = function () {
		jQuery('.header-tabs').on('mouseenter mouseleave', function () {
			jQuery('.header-tabs').removeClass('active');
			jQuery('.header-tabs-content').removeClass('show');
			jQuery(this).addClass('active');
			var stTabId = $(this).attr('id');
			var resTabId = stTabId.replace("dz-", "");
			jQuery('#' + resTabId).addClass('show');
		});
	}

	var handleBgEffect = function () {
		if (jQuery('.bgeffect').length > 0) {
			if (screenWidth > 1023) {
				if (jQuery('.bgeffect').length) {
					var s = skrollr.init({
						edgeStrategy: 'set',
						forceHeight: false,
						easing: {
							WTF: Math.random,
							inverted: function (p) {
								return 1 - p;
							}
						}
					});
				}
			}
		}
	}

	// Handle Smart wizard
	var handleSmartWizard = function () {
		if (jQuery('#smartwizard').length > 0) {
			$('#smartwizard').smartWizard();
		}
	}

	// Handle Smart wizard
	var handleCopyClipboard = function () {
		if (jQuery('#copyButton').length > 0) {
			document.getElementById("copyButton").addEventListener("click", function (e) {
				e.preventDefault;
				$('#copyButton').addClass('active').text('Copied');
				$('#copyTarget').addClass('active');
				copyToClipboard(document.getElementById("copyTarget"));
			});
			function copyToClipboard(elem) {
				// create hidden text element, if it doesn't already exist
				var targetId = "_hiddenCopyText_";
				var isInput = elem.tagName === "INPUT" || elem.tagName === "TEXTAREA";
				var origSelectionStart, origSelectionEnd;
				if (isInput) {

					// can just use the original source element for the selection and copy
					target = elem;
					origSelectionStart = elem.selectionStart;
					origSelectionEnd = elem.selectionEnd;
				} else {

					// must use a temporary form element for the selection and copy
					target = document.getElementById(targetId);
					if (!target) {
						var target = document.createElement("textarea");
						target.style.position = "absolute";
						target.style.left = "-9999px";
						target.style.top = "0";
						target.id = targetId;
						document.body.appendChild(target);
					}
					target.textContent = elem.textContent;
				}

				// select the content
				var currentFocus = document.activeElement;
				target.focus();
				target.setSelectionRange(0, target.value.length);

				// copy the selection
				var succeed;
				try {
					succeed = document.execCommand("copy");
				} catch (e) {
					succeed = false;
				}

				// restore original focus
				if (currentFocus && typeof currentFocus.focus === "function") {
					currentFocus.focus();
				}
				if (isInput) {

					// restore prior selection
					elem.setSelectionRange(origSelectionStart, origSelectionEnd);
				} else {

					// clear temporary content
					target.textContent = "";
				}
				return succeed;
			}
		}
	}

	var isScrolledIntoView = function (elem) {
		var $elem = $(elem);
		var $window = $(window);

		var docViewTop = $window.scrollTop();
		var docViewBottom = docViewTop + $window.height();

		var elemTop = $elem.offset().top;
		var elemBottom = elemTop + $elem.height();

		return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
	}

	var splitImageAnimation = function () {
		$(window).on('scroll', function () {
			$('.split-box').each(function () {
				if (isScrolledIntoView($(this))) {
					$(this).addClass('split-active');
				}
			});
		});
	}

	/* Password Show / Hide */
	var handleShowPass = function () {
		jQuery('.show-pass').on('click', function () {
			var inputType = jQuery(this).parent().find('.dz-password');
			if (inputType.attr('type') == 'password') {
				inputType.attr('type', 'text');
				jQuery(this).addClass('active');
			}
			else {
				inputType.attr('type', 'password');
				jQuery(this).removeClass('active');
			}
		});
	}

	/* Handle Page On Scroll ============ */
	var handlePageOnScroll = function (event) {

		var headerHeight = parseInt($('.header').css('height'), 10);

		$('.navbar-scroll .scroll').on('click', function (event) {
			event.preventDefault();

			jQuery('.navbar-scroll .scroll').parent().removeClass('active');
			jQuery(this).parent().addClass('active');

			if (this.hash !== "") {
				var hash = this.hash;
				var seactionPosition = parseInt($(hash).offset().top, 10);
				var headerHeight = parseInt($('.header').css('height'), 10) - 30;

				var scrollTopPosition = seactionPosition - headerHeight;
				$('html, body').animate({
					scrollTop: scrollTopPosition
				}, 500, function () {

				});
			}
		});

		pageOnScroll();
	}

	/* Page On Scroll ============ */
	var pageOnScroll = function (event) {

		if (jQuery('.navbar-scroll').length > 0) {

			$('.header .sticky-header').addClass('is-fixed');
			var headerHeight = parseInt(jQuery('header .main-bar').height(), 10);

			setTimeout(function () {
				$('.header .sticky-header').removeClass('is-fixed');
			}, 100);

			jQuery(document).on("scroll", function () {

				var scrollPos = jQuery(this).scrollTop();
				jQuery('.navbar-scroll .scroll').each(function () {
					var elementLink = jQuery(this);

					var refElement = jQuery(elementLink.attr("href"));
					var seactionPosition = parseInt(jQuery(this.hash).offset().top, 10);
					var scrollTopPosition = (seactionPosition - headerHeight) - 30;

					if (scrollTopPosition <= scrollPos) {
						elementLink.parent().addClass("active");
						elementLink.parent().siblings().removeClass("active");
					}
				});

			});
		}
	}

	/* Handle Navbar Toggler ============ */
	var handleScreenLock = function () {
		jQuery('.navbar-toggler').on('click', function () {
			jQuery('body').toggleClass('screen-lock');
			jQuery('.styleswitcher').toggleClass('hide');
		});
	}

	/* Function ============ */
	return {
		init: function () {
			boxHover();
			onePageLayout();
			dzTheme();
			homeSearch();
			MagnificPopup();
			scrollTop();
			headerFix();
			handleVideo();
			handleFilterMasonary();
			handleCountDown(WebsiteLaunchDate);
			handleBannerResize();
			handleSelectpicker();
			handelResize();
			lightGallery();
			jQuery('.modal').on('show.bs.modal', reposition);
			wow_animation();
			handleSvgRadiaChart();
			handleCurrentActive();
			handleImageTooltip();
			handleBootstrapTouchSpin();
			priceslider();
			handleFinalCountDown();
			handleHeaderTabs();
			handleBgEffect();
			handleSidebarMenu();
			handleSmartWizard();
			handleCopyClipboard();
			splitImageAnimation();
			handleSupport();
			handlePageOnScroll();
			handleScreenLock();
			handleShowPass();
		},

		load: function () {
			counter();
			masonryBox();
		},

		resize: function () {
			screenWidth = $(window).width();
			dzTheme();
			handleFinalCountDown();
		}
	}

}();

/* Document.ready Start */
jQuery(document).ready(function () {

	Indiro.init();

	$('a[data-toggle="tab"]').click(function () {
		// todo remove snippet on bootstrap v4
		$('a[data-toggle="tab"]').click(function () {
			$($(this).attr('href')).show().addClass('show active').siblings().hide();
		})
	});

	jQuery('.navicon').on('click', function () {
		$(this).toggleClass('open');
	});

	if ($('.js-tilt').length > 0) {
		$('.js-tilt').tilt({
			perspective: 2000,
			transition: true,
		});
	}

	var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
	var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
		return new bootstrap.Popover(popoverTriggerEl)
	})

});
/* Document.ready END */

/* Window Load START */
jQuery(window).on('load', function () {

	Indiro.load();

	if ($('.aos-item').length > 0) {
		AOS.init({
			once: true,
		});
	}

	setTimeout(function () {
		jQuery('#loading-area').addClass('active');
		jQuery('#loading-area').fadeOut(1000);
	}, 1000);

});
/*  Window Load END */

/* Window Resize START */
jQuery(window).on('resize', function () {
	Indiro.resize();
});
/*  Window Resize END */
