<!DOCTYPE html>
<html lang="tr">
    <?php include 'partials/head.php'; ?>

    <body id="body" class="tt-magic-cursor inside-page">
        <?php include 'partials/header.php'; ?>
        <!-- Header End -->

        <!-- Start Breadcrumb section -->
        <div class="breadcrumb-section" style="background-image: linear-gradient(91.45deg, #000000 17.96%, rgba(0, 0, 0, 0.9) 44.49%, rgba(0, 0, 0, 0.8) 67.58%, rgba(0, 0, 0, 0.5) 98.52%), url(assets/img/inner-pages/breadcrumb-bg1.jpg);">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="banner-content">
                            <span>Hizmetlerimiz</span>
                            <h1>Hizmetlerimiz</h1>
                            <ul class="breadcrumb-list">
                                <li><a href="index.php">Anasayfa</a></li>
                                <li>Hizmetlerimiz</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Breadcrumb section -->

        <div class="home5-service-section mb-120">
            <div class="container">
                <div class="service-slider-area">
                    <div class="row g-4 align-items-center justify-content-between">
                        <div class="col-xl-6 col-lg-3">
                            <div class="service-card2">
                                <div class="icon">
                                    <svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path
                                                d="M44.9714 8.63648H20.3805C20.1078 8.63648 19.8623 8.47284 19.7532 8.22739C19.6441 7.98193 19.6987 7.69102 19.8805 7.49102C20.0351 7.32739 20.3441 6.86375 20.2987 6.53648C20.2896 6.44557 20.2441 6.30012 19.9987 6.12739C19.8351 6.0183 19.726 5.83648 19.7078 5.63648C19.6896 5.43648 19.7532 5.24557 19.8805 5.09102C20.0351 4.9183 20.3441 4.46375 20.2987 4.12739C20.2987 4.04557 20.2532 3.90012 19.9987 3.72739C19.7441 3.55466 19.6441 3.24557 19.726 2.96375C19.8169 2.67284 20.0805 2.48193 20.3805 2.48193H44.9714C45.3441 2.48193 45.6532 2.79102 45.6532 3.16375C45.6532 3.53648 45.3441 3.84557 44.9714 3.84557H21.6441C21.6532 3.89102 21.6623 3.93648 21.6623 3.98193C21.726 4.56375 21.5078 5.10012 21.2896 5.47284C21.5441 5.80012 21.6351 6.12739 21.6623 6.38193C21.6987 6.70012 21.6441 7.00012 21.5623 7.27284H44.9714C45.1523 7.27284 45.3257 7.34468 45.4535 7.47254C45.5814 7.60041 45.6532 7.77383 45.6532 7.95466C45.6532 8.13549 45.5814 8.30891 45.4535 8.43678C45.3257 8.56464 45.1523 8.63648 44.9714 8.63648Z"
                                            />
                                            <path
                                                d="M20.381 8.63646C20.2901 8.63646 20.1992 8.61828 20.1083 8.58191L14.6083 6.19101C14.3629 6.08191 14.1992 5.83646 14.1992 5.56373C14.1992 5.29101 14.3629 5.04555 14.6083 4.93646L20.1083 2.53646C20.2747 2.46413 20.463 2.46085 20.6317 2.52734C20.8005 2.59383 20.936 2.72464 21.0083 2.89101C21.0806 3.05737 21.0839 3.24565 21.0174 3.41443C20.9509 3.58322 20.8201 3.71867 20.6538 3.79101L16.5901 5.56373L20.6538 7.32737C20.9992 7.48191 21.1538 7.88192 21.0083 8.22737C20.8992 8.48191 20.6447 8.63646 20.381 8.63646ZM48.8992 8.63646H47.472C47.0992 8.63646 46.7901 8.32737 46.7901 7.95464V3.16373C46.7901 2.79101 47.0992 2.48191 47.472 2.48191H48.8992C50.2356 2.48191 51.3174 3.49101 51.3174 4.73646V6.38191C51.3174 7.62737 50.2265 8.63646 48.8992 8.63646ZM48.1538 7.27282H48.8992C49.481 7.27282 49.9538 6.87282 49.9538 6.38191V4.74555C49.9538 4.25464 49.481 3.85464 48.8992 3.85464H48.1538V7.27282Z"
                                            />
                                            <path
                                                d="M47.4728 8.63648H43.891C43.5182 8.63648 43.2092 8.32739 43.2092 7.95466V3.16375C43.2092 2.79102 43.5182 2.48193 43.891 2.48193H47.4728C47.8455 2.48193 48.1546 2.79102 48.1546 3.16375V7.95466C48.1546 8.32739 47.8455 8.63648 47.4728 8.63648ZM44.5637 7.27284H46.7819V3.84557H44.5637V7.27284ZM53.3183 57.5183H10.2819C6.59098 57.5183 3.49098 54.7547 3.0728 51.1001C3.04553 50.8274 3.02734 50.5456 3.02734 50.2638C3.02734 46.2728 6.28189 43.0183 10.2819 43.0183C10.9001 43.0183 11.491 43.091 12.0364 43.2456C13.7546 43.6638 15.191 44.6728 16.1728 46.0274V14.5819C16.1728 14.1728 16.1273 13.7728 16.0546 13.3819C16.0092 13.1819 16.0637 12.9728 16.191 12.8092C16.3183 12.6456 16.5183 12.5547 16.7183 12.5547H53.3273C55.3455 12.5547 56.9819 14.191 56.9819 16.2092V53.8456C56.9728 55.8728 55.3364 57.5183 53.3183 57.5183ZM10.2819 44.3819C7.03644 44.3819 4.39098 47.0183 4.39098 50.2638C4.39098 50.491 4.40916 50.7183 4.43643 50.9456C4.60004 52.3806 5.28655 53.705 6.36483 54.6659C7.44311 55.6268 8.83759 56.1568 10.2819 56.1547H53.3273C54.591 56.1547 55.6183 55.1274 55.6183 53.8638V16.2274C55.6183 14.9638 54.591 13.9365 53.3273 13.9365H17.5092C17.5273 14.1547 17.5364 14.3728 17.5364 14.591V51.0274C17.5364 51.4001 17.2273 51.7092 16.8546 51.7092C16.4819 51.7092 16.1728 51.4001 16.1728 51.0274V50.2728C16.1728 47.5547 14.3364 45.2183 11.7001 44.5728C11.2455 44.4365 10.7728 44.3819 10.2819 44.3819Z"
                                            />
                                            <path
                                                d="M3.74485 51.7002C3.37212 51.7002 3.01758 51.3911 3.01758 51.0184V50.2638C3.01758 49.8911 3.32667 49.582 3.6994 49.582C4.07212 49.582 4.38121 49.8911 4.38121 50.2638C4.38121 50.4911 4.3994 50.7184 4.42667 50.9457C4.44485 51.1366 4.39031 51.3275 4.25394 51.4729C4.12667 51.6184 3.94485 51.7002 3.74485 51.7002Z"
                                            />
                                            <path
                                                d="M16.8546 50.9456C16.4819 50.9456 16.1728 50.6365 16.1728 50.2638V14.5819C16.1728 14.1728 16.1273 13.7728 16.0546 13.3819C15.491 10.6638 13.0637 8.69103 10.2819 8.69103C7.03644 8.69103 4.39098 11.3365 4.39098 14.5819V50.2638C4.39098 50.6365 4.08189 50.9456 3.70916 50.9456C3.33643 50.9456 3.02734 50.6365 3.02734 50.2638V14.5819C3.02734 10.5819 6.28189 7.32739 10.2819 7.32739C13.7001 7.32739 16.691 9.75466 17.3819 13.1092C17.4819 13.591 17.5364 14.0819 17.5364 14.5819V50.2638C17.5364 50.6365 17.2273 50.9456 16.8546 50.9456Z"
                                            />
                                            <path
                                                d="M6.43523 17.7C6.0625 17.7 5.75341 17.3909 5.75341 17.0182V14.9818C5.72614 14.0818 5.8625 13.3364 6.1625 12.7091C6.79886 11.2546 8.2625 10.2091 9.88068 10.0727C10.2534 10.0364 10.5898 10.3182 10.617 10.6909C10.6534 11.0637 10.3716 11.4 9.99886 11.4273C8.88977 11.5182 7.84432 12.2637 7.40795 13.2727C7.18977 13.7273 7.09886 14.2636 7.12614 14.9636V17.0182C7.11705 17.4 6.80795 17.7 6.43523 17.7ZM6.43523 22.6909C6.0625 22.6909 5.75341 22.3818 5.75341 22.0091V20.4909C5.75341 20.1182 6.0625 19.8091 6.43523 19.8091C6.80795 19.8091 7.11705 20.1182 7.11705 20.4909V22.0091C7.11705 22.3818 6.80795 22.6909 6.43523 22.6909ZM51.1261 50.8091H21.2261C20.8534 50.8091 20.5443 50.5 20.5443 50.1273V20.2364C20.5443 19.8637 20.8534 19.5546 21.2261 19.5546H51.1261C51.4989 19.5546 51.808 19.8637 51.808 20.2364V50.1364C51.808 50.5091 51.4989 50.8091 51.1261 50.8091ZM21.908 49.4455H50.4443V20.9182H21.908V49.4455Z"
                                            />
                                            <path
                                                d="M39.6722 35.8638H36.1722C35.7995 35.8638 35.4904 35.5547 35.4904 35.182V20.2365C35.4904 19.8638 35.7995 19.5547 36.1722 19.5547C36.5449 19.5547 36.854 19.8638 36.854 20.2365V34.5001H39.6722C39.853 34.5001 40.0264 34.572 40.1543 34.6998C40.2822 34.8277 40.354 35.0011 40.354 35.182C40.354 35.3628 40.2822 35.5362 40.1543 35.6641C40.0264 35.7919 39.853 35.8638 39.6722 35.8638ZM28.1449 50.8092C27.7722 50.8092 27.4631 50.5001 27.4631 50.1274V46.7638C27.4631 46.3911 27.7722 46.082 28.1449 46.082C28.5176 46.082 28.8267 46.3911 28.8267 46.7638V50.1274C28.8267 50.5092 28.5267 50.8092 28.1449 50.8092ZM28.1449 44.2729C27.7722 44.2729 27.4631 43.9638 27.4631 43.5911V41.3274C27.4631 40.9547 27.7722 40.6456 28.1449 40.6456C28.5176 40.6456 28.8267 40.9547 28.8267 41.3274V43.5911C28.8267 43.9729 28.5267 44.2729 28.1449 44.2729ZM28.1449 39.2365C27.7722 39.2365 27.4631 38.9274 27.4631 38.5547V37.4183C27.4631 37.0456 27.7722 36.7365 28.1449 36.7365C28.5176 36.7365 28.8267 37.0456 28.8267 37.4183V38.5547C28.8267 38.9274 28.5267 39.2365 28.1449 39.2365ZM29.2813 35.8638H21.2267C20.854 35.8638 20.5449 35.5547 20.5449 35.182C20.5449 34.8092 20.854 34.5001 21.2267 34.5001H29.2813C29.654 34.5001 29.9631 34.8092 29.9631 35.182C29.9631 35.5547 29.654 35.8638 29.2813 35.8638ZM33.3995 35.8638H31.854C31.4813 35.8638 31.1722 35.5547 31.1722 35.182C31.1722 34.8092 31.4813 34.5001 31.854 34.5001H33.3995C33.7722 34.5001 34.0813 34.8092 34.0813 35.182C34.0813 35.5547 33.7722 35.8638 33.3995 35.8638ZM41.6631 47.9547C40.5722 47.9547 39.4722 47.6274 38.5176 46.9638C38.41 46.8903 38.3275 46.7856 38.2813 46.6638C38.0887 46.188 38.092 45.6554 38.2904 45.182C38.5358 44.582 39.0904 44.1365 39.754 44.0274C40.054 43.9729 40.3358 44.0001 40.5813 44.0274L40.8631 44.0547C41.0631 44.0547 41.1631 44.0183 41.1813 44.0092C41.1995 43.9729 41.2086 43.7911 41.2176 43.682C41.2358 43.4183 41.254 43.0911 41.4267 42.7729C41.8631 41.9911 42.8176 41.9274 43.1358 41.9092C44.3581 41.853 45.577 42.0769 46.6995 42.5638C46.9813 42.6911 47.1449 42.982 47.0995 43.282C46.9332 44.4375 46.3936 45.507 45.5631 46.3274C45.0529 46.843 44.4455 47.2522 43.776 47.5315C43.1066 47.8109 42.3885 47.9547 41.6631 47.9547ZM39.4995 45.9729C40.29 46.4607 41.2223 46.6669 42.1449 46.558C43.0674 46.449 43.9261 46.0314 44.5813 45.3729C45.0813 44.8729 45.4358 44.2729 45.6176 43.6092C44.8449 43.3456 44.0176 43.2274 43.1904 43.2638C42.6813 43.2911 42.6086 43.4183 42.6086 43.4183C42.5813 43.4638 42.5722 43.6365 42.5631 43.7547C42.5449 44.0456 42.5176 44.4456 42.2631 44.8092C41.954 45.2274 41.4358 45.4456 40.7995 45.4092C40.6813 45.4092 40.554 45.3911 40.4358 45.382C40.254 45.3638 40.0904 45.3456 39.9722 45.3729C39.8315 45.3932 39.704 45.4668 39.6161 45.5785C39.5281 45.6902 39.4863 45.8313 39.4995 45.9729Z"
                                            />
                                            <path
                                                d="M38.9087 47.0819C38.7723 47.0819 38.6359 47.0455 38.5178 46.9637C38.2541 46.7819 38.0087 46.5728 37.7814 46.3455C36.5359 45.1001 35.9632 43.3091 36.2541 41.5546C36.2996 41.2819 36.5087 41.0637 36.7723 41.0001C37.0359 40.9364 37.3178 41.0455 37.4814 41.2728C37.6359 41.5001 37.8087 41.6637 37.9905 41.791C38.2359 41.9546 38.5178 42.0001 38.7359 41.9273C38.9632 41.8364 39.1814 41.5637 39.3905 41.091L39.4905 40.8546C39.6814 40.4001 39.8905 39.8819 40.2996 39.4728C40.6087 39.1637 40.9723 38.9637 41.2905 38.791C41.4723 38.691 41.645 38.591 41.8087 38.4728C42.0541 38.291 42.1814 38.0364 42.1632 37.9182C42.1444 37.8059 42.1537 37.6908 42.1902 37.5829C42.2266 37.4751 42.2892 37.3779 42.3723 37.3001C42.545 37.1455 42.7814 37.0819 42.9996 37.1364C43.9632 37.3728 44.8359 37.8728 45.545 38.5819C46.1543 39.1919 46.6111 39.9372 46.878 40.757C47.145 41.5769 47.2147 42.4482 47.0814 43.3001C47.0268 43.6728 46.6723 43.9273 46.2996 43.8637C46.2108 43.8502 46.1257 43.8192 46.049 43.7724C45.9724 43.7256 45.9059 43.664 45.8535 43.5912C45.801 43.5184 45.7635 43.4359 45.7433 43.3484C45.7232 43.2609 45.7206 43.1703 45.7359 43.0819C45.9359 41.791 45.5087 40.4728 44.5814 39.5455C44.2178 39.1819 43.7996 38.9001 43.345 38.691C43.1723 39.0455 42.8996 39.3546 42.6087 39.5637C42.4087 39.7091 42.1814 39.8364 41.9541 39.9637C41.6905 40.1091 41.445 40.2455 41.2723 40.4182C41.0541 40.6455 40.9087 40.991 40.7541 41.3637L40.6359 41.6364C40.3996 42.1728 39.9905 42.9001 39.2087 43.2001C38.6996 43.391 38.1178 43.3637 37.5905 43.1273C37.6787 43.6718 37.8755 44.193 38.1691 44.6599C38.4627 45.1269 38.8471 45.53 39.2996 45.8455C39.6087 46.0637 39.6814 46.491 39.4723 46.791C39.3359 46.9819 39.1268 47.0819 38.9087 47.0819Z"
                                            />
                                            <path
                                                d="M36.9265 42.3455C36.8902 42.3455 36.8538 42.3455 36.8084 42.3364C36.7206 42.3215 36.6366 42.2895 36.5612 42.2421C36.4858 42.1948 36.4205 42.1331 36.369 42.0604C36.3175 41.9878 36.2808 41.9058 36.261 41.819C36.2413 41.7322 36.2388 41.6423 36.2538 41.5546C36.4447 40.4273 36.972 39.4 37.7902 38.5909C38.4619 37.9268 39.2922 37.4454 40.2023 37.1924C41.1124 36.9394 42.0721 36.9233 42.9902 37.1455C43.0773 37.167 43.1594 37.2054 43.2317 37.2586C43.304 37.3118 43.3651 37.3787 43.4115 37.4556C43.4579 37.5324 43.4888 37.6176 43.5023 37.7063C43.5158 37.7951 43.5117 37.8856 43.4902 37.9727C43.4687 38.0599 43.4302 38.142 43.377 38.2142C43.3238 38.2865 43.2569 38.3476 43.1801 38.3941C43.1033 38.4405 43.0181 38.4713 42.9293 38.4848C42.8406 38.4983 42.7501 38.4942 42.6629 38.4727C41.2629 38.1273 39.7629 38.5455 38.7447 39.5637C38.1356 40.1727 37.7356 40.9455 37.5902 41.7909C37.5447 42.1091 37.2538 42.3455 36.9265 42.3455ZM43.1265 30.8273C42.1629 30.8273 41.1993 30.4637 40.4629 29.7273C38.9902 28.2546 38.9902 25.8636 40.4629 24.3909C41.9356 22.9182 44.3265 22.9182 45.7993 24.3909C46.5084 25.1 46.9084 26.0546 46.9084 27.0546C46.9084 28.0546 46.5175 29.0091 45.7993 29.7182C45.0629 30.4546 44.0993 30.8273 43.1265 30.8273ZM43.1265 24.6455C42.5084 24.6455 41.8902 24.8818 41.4265 25.3455C40.9768 25.7988 40.7244 26.4114 40.7244 27.05C40.7244 27.6886 40.9768 28.3013 41.4265 28.7546C41.8798 29.2043 42.4925 29.4567 43.1311 29.4567C43.7697 29.4567 44.3823 29.2043 44.8356 28.7546C45.2902 28.3 45.5447 27.6909 45.5447 27.0546C45.5447 26.4182 45.2902 25.8091 44.8356 25.3546C44.6115 25.1296 44.3452 24.9511 44.0519 24.8294C43.7586 24.7077 43.4441 24.6452 43.1265 24.6455Z"
                                            />
                                            <path
                                                d="M38.4356 32.182C38.0992 32.182 37.881 32.0456 37.7174 31.8911C37.4356 31.6093 36.6901 30.8638 39.6265 27.382C39.8719 27.0911 40.2992 27.0547 40.5901 27.3002C40.881 27.5456 40.9174 27.9729 40.6719 28.2638C39.7447 29.3638 39.2538 30.1366 39.0083 30.6093C39.4538 30.382 40.1719 29.9184 41.2083 29.0547C41.8629 28.5184 42.5538 27.882 43.2629 27.1729C43.9719 26.4638 44.6083 25.7729 45.1356 25.1275C45.9992 24.0911 46.4629 23.3729 46.6901 22.9275C46.2174 23.1729 45.4538 23.6638 44.3447 24.5911C44.0538 24.8366 43.6265 24.8002 43.381 24.5093C43.1356 24.2184 43.1719 23.7911 43.4629 23.5456C46.9356 20.6093 47.6901 21.3547 47.9629 21.6366C48.4356 22.1093 48.6538 23.0275 46.181 25.9911C45.6265 26.6729 44.9629 27.3911 44.2174 28.1366C43.481 28.882 42.7538 29.5366 42.0719 30.1002C40.1356 31.7184 39.0719 32.182 38.4356 32.182ZM29.281 32.6002C28.1985 32.6002 27.1602 32.1701 26.3948 31.4047C25.6293 30.6392 25.1992 29.6009 25.1992 28.5184C25.1992 27.4358 25.6293 26.3976 26.3948 25.6321C27.1602 24.8666 28.1985 24.4366 29.281 24.4366C30.3636 24.4366 31.4018 24.8666 32.1673 25.6321C32.9328 26.3976 33.3629 27.4358 33.3629 28.5184C33.3629 29.6009 32.9328 30.6392 32.1673 31.4047C31.4018 32.1701 30.3636 32.6002 29.281 32.6002ZM29.281 25.8002C27.781 25.8002 26.5629 27.0184 26.5629 28.5184C26.5629 30.0184 27.781 31.2366 29.281 31.2366C30.781 31.2366 31.9992 30.0184 31.9992 28.5184C31.9992 27.0184 30.7719 25.8002 29.281 25.8002Z"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <h3><a href="hizmet-detay.php">İnşaat</a></h3>
                                <p>Kaba–ince işler, betonarme ve cephe uygulamalarıyla, standartlara uygun anahtar teslim yapılar üretiyoruz.</p>
                                <a href="hizmet-detay.php" class="more-btn">Hizmeti İncele</a>
                                <a href="hizmet-detay.php" class="arrow">
                                    <svg width="80" height="80" viewBox="0 0 80 80" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path d="M79.604 79.999L0 79.999L-1.30275e-06 65.0973L64.9505 0.000230198L80 0.000228882L80 14.902L35.6436 58.8229L79.604 58.4307L79.604 79.999Z" />
                                            <path d="M0.000577353 -9.57446e-06L0.000581741 50.1953L21.3867 29.0192L21.3867 -1.14441e-05L0.000577353 -9.57446e-06Z" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-3">
                            <div class="service-card2">
                                <div class="icon">
                                    <svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path
                                                d="M59.0588 38.3602L58.1213 27.1102C58.1019 26.8758 57.9951 26.6572 57.8221 26.4979C57.6491 26.3386 57.4225 26.2501 57.1873 26.25H47.9295C47.6961 26.2498 47.471 26.3369 47.2984 26.494C47.1259 26.6512 47.0183 26.8672 46.9967 27.0996L45.942 38.3496C45.9294 38.4796 45.9442 38.6108 45.9853 38.7347C46.0265 38.8586 46.0932 38.9725 46.181 39.0691C46.2689 39.1657 46.3761 39.2429 46.4955 39.2955C46.615 39.3482 46.7442 39.3753 46.8748 39.375H51.5623C51.5597 41.612 50.67 43.7566 49.0882 45.3384C47.5064 46.9202 45.3618 47.8099 43.1248 47.8125H39.3748C37.1378 47.8099 34.9932 46.9202 33.4114 45.3384C31.8297 43.7566 30.9399 41.612 30.9373 39.375V24.2742C31.5472 24.8998 32.2761 25.397 33.0812 25.7363C33.8863 26.0756 34.7511 26.2503 35.6248 26.25H39.3748C40.9522 26.2477 42.4761 25.6783 43.6684 24.6456C44.8608 23.6129 45.6419 22.1859 45.8693 20.625H50.6248C50.7545 20.6252 50.8828 20.5984 51.0016 20.5464C51.1204 20.4944 51.227 20.4183 51.3148 20.3229C51.4027 20.2274 51.4697 20.1148 51.5117 19.9921C51.5537 19.8694 51.5697 19.7394 51.5588 19.6102L50.6213 8.36016C50.6019 8.12576 50.4951 7.90722 50.3221 7.74789C50.1491 7.58856 49.9225 7.50008 49.6873 7.5H40.4295C40.1961 7.49982 39.971 7.58685 39.7984 7.74403C39.6259 7.90121 39.5183 8.11719 39.4967 8.34961L38.442 19.5996C38.4294 19.7296 38.4442 19.8608 38.4853 19.9847C38.5265 20.1086 38.5932 20.2225 38.681 20.3191C38.7689 20.4157 38.8761 20.4929 38.9955 20.5455C39.115 20.5982 39.2442 20.6253 39.3748 20.625H43.9686C43.751 21.6831 43.1753 22.6338 42.3385 23.3169C41.5018 24 40.455 24.3737 39.3748 24.375H35.6248C34.382 24.3738 33.1904 23.8795 32.3116 23.0007C31.4328 22.1219 30.9386 20.9303 30.9373 19.6875V5.625H33.7498C33.9466 5.62501 34.1384 5.56311 34.298 5.44807C34.4576 5.33302 34.577 5.17066 34.6393 4.98398L35.5768 2.17148C35.6237 2.03055 35.6366 1.88047 35.6142 1.73362C35.5918 1.58676 35.5348 1.44733 35.4479 1.32681C35.361 1.2063 35.2468 1.10816 35.1145 1.04047C34.9823 0.972782 34.8359 0.937489 34.6873 0.9375H25.3123C25.1638 0.937489 25.0173 0.972782 24.8851 1.04047C24.7528 1.10816 24.6386 1.2063 24.5517 1.32681C24.4649 1.44733 24.4079 1.58676 24.3855 1.73362C24.3631 1.88047 24.3759 2.03055 24.4229 2.17148L25.3604 4.98398C25.4226 5.17066 25.542 5.33302 25.7016 5.44807C25.8612 5.56311 26.053 5.62501 26.2498 5.625H29.0623V19.6875C29.0611 20.9303 28.5668 22.1219 27.688 23.0007C26.8092 23.8795 25.6176 24.3738 24.3748 24.375H20.6248C19.5446 24.3737 18.4979 24 17.6611 23.3169C16.8243 22.6338 16.2486 21.6831 16.0311 20.625H20.6248C20.7545 20.6252 20.8828 20.5984 21.0016 20.5464C21.1204 20.4944 21.227 20.4183 21.3149 20.3229C21.4027 20.2274 21.4697 20.1148 21.5117 19.9921C21.5537 19.8694 21.5697 19.7394 21.5588 19.6102L20.6213 8.36016C20.6019 8.12576 20.4951 7.90722 20.3221 7.74789C20.1491 7.58856 19.9225 7.50008 19.6873 7.5H10.3123C10.0771 7.50008 9.85054 7.58856 9.67754 7.74789C9.50453 7.90722 9.39773 8.12576 9.37833 8.36016L8.44083 19.6102C8.4299 19.7394 8.44594 19.8694 8.48794 19.9921C8.52993 20.1148 8.59696 20.2274 8.68477 20.3229C8.77259 20.4183 8.87927 20.4944 8.99805 20.5464C9.11684 20.5984 9.24514 20.6252 9.37481 20.625H14.1303C14.3577 22.1859 15.1389 23.6129 16.3312 24.6456C17.5235 25.6783 19.0475 26.2477 20.6248 26.25H24.3748C25.2485 26.2503 26.1134 26.0756 26.9184 25.7363C27.7235 25.397 28.4525 24.8998 29.0623 24.2742V39.375C29.0597 41.612 28.17 43.7566 26.5882 45.3384C25.0064 46.9202 22.8618 47.8099 20.6248 47.8125H16.8748C14.6378 47.8099 12.4932 46.9202 10.9114 45.3384C9.32966 43.7566 8.43989 41.612 8.43731 39.375H13.1248C13.2545 39.3752 13.3828 39.3484 13.5016 39.2964C13.6204 39.2444 13.727 39.1683 13.8149 39.0729C13.9027 38.9774 13.9697 38.8648 14.0117 38.7421C14.0537 38.6194 14.0697 38.4894 14.0588 38.3602L13.1213 27.1102C13.1019 26.8758 12.9951 26.6572 12.8221 26.4979C12.6491 26.3386 12.4225 26.2501 12.1873 26.25H2.81231C2.57712 26.2501 2.35054 26.3386 2.17754 26.4979C2.00453 26.6572 1.89773 26.8758 1.87833 27.1102L0.940829 38.3602C0.929902 38.4894 0.945944 38.6194 0.987938 38.7421C1.02993 38.8648 1.09696 38.9774 1.18477 39.0729C1.27259 39.1683 1.37927 39.2444 1.49806 39.2964C1.61684 39.3484 1.74514 39.3752 1.87481 39.375H6.56231V53.5992C5.9368 53.8204 5.40961 54.2555 5.07391 54.8278C4.73821 55.4001 4.61563 56.0726 4.72782 56.7265C4.84001 57.3804 5.17975 57.9736 5.68701 58.4012C6.19426 58.8288 6.83636 59.0634 7.49981 59.0634C8.16327 59.0634 8.80537 58.8288 9.31262 58.4012C9.81987 57.9736 10.1596 57.3804 10.2718 56.7265C10.384 56.0726 10.2614 55.4001 9.92572 54.8278C9.59002 54.2555 9.06283 53.8204 8.43731 53.5992V45.2977C9.38778 46.6532 10.6508 47.7598 12.1195 48.5239C13.5881 49.2881 15.2193 49.6872 16.8748 49.6875H20.6248C22.2804 49.6872 23.9115 49.2881 25.3802 48.5239C26.8488 47.7598 28.1118 46.6532 29.0623 45.2977V53.5992C28.4368 53.8204 27.9096 54.2555 27.5739 54.8278C27.2382 55.4001 27.1156 56.0726 27.2278 56.7265C27.34 57.3804 27.6798 57.9736 28.187 58.4012C28.6943 58.8288 29.3364 59.0634 29.9998 59.0634C30.6633 59.0634 31.3054 58.8288 31.8126 58.4012C32.3199 57.9736 32.6596 57.3804 32.7718 56.7265C32.884 56.0726 32.7614 55.4001 32.4257 54.8278C32.09 54.2555 31.5628 53.8204 30.9373 53.5992V45.2977C31.8878 46.6532 33.1508 47.7598 34.6195 48.5239C36.0881 49.2881 37.7193 49.6872 39.3748 49.6875H43.1248C44.7804 49.6872 46.4115 49.2881 47.8802 48.5239C49.3488 47.7598 50.6118 46.6532 51.5623 45.2977V53.5992C50.9368 53.8204 50.4096 54.2555 50.0739 54.8278C49.7382 55.4001 49.6156 56.0726 49.7278 56.7265C49.84 57.3804 50.1798 57.9736 50.687 58.4012C51.1943 58.8288 51.8364 59.0634 52.4998 59.0634C53.1633 59.0634 53.8054 58.8288 54.3126 58.4012C54.8199 57.9736 55.1596 57.3804 55.2718 56.7265C55.384 56.0726 55.2614 55.4001 54.9257 54.8278C54.59 54.2555 54.0628 53.8204 53.4373 53.5992V39.375H58.1248C58.2545 39.3752 58.3828 39.3484 58.5016 39.2964C58.6204 39.2444 58.727 39.1683 58.8148 39.0729C58.9027 38.9774 58.9697 38.8648 59.0117 38.7421C59.0537 38.6194 59.0697 38.4894 59.0588 38.3602ZM40.4049 18.75L41.2838 9.375H48.8248L49.6065 18.75H40.4049ZM10.3932 18.75L11.1748 9.375H18.8248L19.6065 18.75H10.3932ZM7.49981 57.1875C7.31439 57.1875 7.13314 57.1325 6.97897 57.0295C6.82479 56.9265 6.70463 56.7801 6.63368 56.6088C6.56272 56.4375 6.54415 56.249 6.58033 56.0671C6.6165 55.8852 6.70579 55.7182 6.8369 55.5871C6.96801 55.456 7.13506 55.3667 7.31692 55.3305C7.49877 55.2943 7.68727 55.3129 7.85858 55.3839C8.02988 55.4548 8.1763 55.575 8.27932 55.7292C8.38233 55.8833 8.43731 56.0646 8.43731 56.25C8.43697 56.4985 8.33809 56.7368 8.16235 56.9125C7.98661 57.0883 7.74835 57.1872 7.49981 57.1875ZM2.89317 37.5L3.67481 28.125H11.3248L12.1065 37.5H2.89317ZM29.9998 57.1875C29.8144 57.1875 29.6331 57.1325 29.479 57.0295C29.3248 56.9265 29.2046 56.7801 29.1337 56.6088C29.0627 56.4375 29.0442 56.249 29.0803 56.0671C29.1165 55.8852 29.2058 55.7182 29.3369 55.5871C29.468 55.456 29.6351 55.3667 29.8169 55.3305C29.9988 55.2943 30.1873 55.3129 30.3586 55.3839C30.5299 55.4548 30.6763 55.575 30.7793 55.7292C30.8823 55.8833 30.9373 56.0646 30.9373 56.25C30.937 56.4985 30.8381 56.7368 30.6623 56.9125C30.4866 57.0883 30.2483 57.1872 29.9998 57.1875ZM26.926 3.75L26.6131 2.8125H33.3865L33.0736 3.75H26.926ZM52.4998 57.1875C52.3144 57.1875 52.1331 57.1325 51.979 57.0295C51.8248 56.9265 51.7046 56.7801 51.6337 56.6088C51.5627 56.4375 51.5442 56.249 51.5803 56.0671C51.6165 55.8852 51.7058 55.7182 51.8369 55.5871C51.968 55.456 52.1351 55.3667 52.3169 55.3305C52.4988 55.2943 52.6873 55.3129 52.8586 55.3839C53.0299 55.4548 53.1763 55.575 53.2793 55.7292C53.3823 55.8833 53.4373 56.0646 53.4373 56.25C53.437 56.4985 53.3381 56.7368 53.1623 56.9125C52.9866 57.0883 52.7483 57.1872 52.4998 57.1875ZM47.9049 37.5L48.7838 28.125H56.3248L57.1064 37.5H47.9049Z"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <h3><a href="hizmet-detay.php">Mimarlık & Mühendislik</a></h3>
                                <p>İhtiyaca özel konsept, statik–mekanik çözümler ve maliyet optimizasyonu ile uygulanabilir projeler tasarlıyoruz.</p>

                                <a href="hizmet-detay.php" class="more-btn">Hizmeti İncele</a>
                                <a href="hizmet-detay.php" class="arrow">
                                    <svg width="80" height="80" viewBox="0 0 80 80" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path d="M79.604 79.999L0 79.999L-1.30275e-06 65.0973L64.9505 0.000230198L80 0.000228882L80 14.902L35.6436 58.8229L79.604 58.4307L79.604 79.999Z" />
                                            <path d="M0.000577353 -9.57446e-06L0.000581741 50.1953L21.3867 29.0192L21.3867 -1.14441e-05L0.000577353 -9.57446e-06Z" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-3">
                            <div class="service-card2">
                                <div class="icon">
                                    <svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path
                                                d="M54.3334 24.5272H5.66789C4.63289 24.5272 3.79102 25.3694 3.79102 26.4044V27.8921C3.79102 28.9271 4.63289 29.7693 5.66789 29.7693H6.5673V52.5517C6.56727 52.6593 6.58844 52.7658 6.62959 52.8652C6.67074 52.9646 6.73106 53.0549 6.80712 53.1309C6.88318 53.207 6.97348 53.2673 7.07287 53.3085C7.17225 53.3496 7.27876 53.3708 7.38633 53.3708H10.5026L9.85711 56.8805C9.6607 57.946 11.2718 58.2427 11.4681 57.1764L12.168 53.3706H24.2202L24.9202 57.1764C25.1183 58.2582 26.7264 57.9399 26.5311 56.8805L25.8855 53.3708H34.1159L33.4703 56.8805C33.2737 57.9468 34.8861 58.2418 35.0813 57.1764L35.7812 53.3706H47.8337L48.5337 57.1764C48.7318 58.2582 50.3399 57.9399 50.1447 56.8805L49.4991 53.3708H52.615C52.7225 53.3708 52.829 53.3496 52.9284 53.3085C53.0278 53.2673 53.1181 53.207 53.1942 53.1309C53.2702 53.0549 53.3306 52.9646 53.3717 52.8652C53.4129 52.7658 53.434 52.6593 53.434 52.5517V29.7693H54.3334C55.3684 29.7693 56.2106 28.9271 56.2106 27.8921V26.4044C56.2106 25.3694 55.3684 24.5272 54.3334 24.5272ZM12.4692 51.7328L12.9724 48.9965H23.4155L23.9188 51.7328H12.4692ZM23.0872 36.318L23.1093 38.3048L22.4412 38.3063C22.4381 38.3063 22.4355 38.3048 22.4326 38.3048H13.9553C13.9136 38.3048 13.8763 38.3199 13.8361 38.326L13.301 38.3272L13.2786 36.3179H23.0872V36.318ZM14.6375 39.9429H21.7504L23.1143 47.3585H13.2738L14.6375 39.9429ZM36.0824 51.7328L36.5857 48.9965H47.029L47.5323 51.7328H36.0824ZM46.7007 36.318L46.7228 38.3048L46.0547 38.3063C46.0516 38.3063 46.0491 38.3048 46.0461 38.3048H37.5688C37.5271 38.3048 37.4898 38.3199 37.4496 38.326L36.9145 38.3272L36.8922 36.3179H46.7007V36.318ZM38.2509 39.9429H45.3638L46.7277 47.3585H36.887L38.2509 39.9429ZM51.7958 51.7328H49.1978L47.0238 39.9125C47.7711 39.7708 48.3386 39.1151 48.3386 38.3272V36.2955C48.3386 35.4044 47.6139 34.6798 46.7229 34.6798H36.8922C36.0011 34.6798 35.2765 35.4045 35.2765 36.2955V38.3272C35.2765 39.1151 35.8439 39.7708 36.5912 39.9125L34.4173 51.7328H25.5845L23.4105 39.9125C24.1579 39.7708 24.7253 39.1151 24.7253 38.3272V36.2955C24.7253 35.4044 24.0006 34.6798 23.1096 34.6798H13.2789C12.3878 34.6798 11.6632 35.4045 11.6632 36.2955V38.3272C11.6632 39.1151 12.2306 39.7708 12.9779 39.9125L10.8039 51.7328H8.20547V29.7694H51.7958V51.7328ZM54.5726 27.8922C54.5725 27.9556 54.5473 28.0164 54.5025 28.0613C54.4576 28.1061 54.3968 28.1313 54.3334 28.1314H5.66789C5.60454 28.1313 5.54382 28.106 5.49907 28.0612C5.45431 28.0163 5.42918 27.9556 5.42918 27.8922V26.4045C5.42918 26.2726 5.53641 26.1653 5.66789 26.1653H54.3334C54.4654 26.1653 54.5726 26.2726 54.5726 26.4045V27.8922ZM19.8202 2.15186C19.7126 2.15182 19.6061 2.17299 19.5067 2.21414C19.4073 2.25529 19.317 2.31561 19.241 2.39167C19.1649 2.46773 19.1046 2.55803 19.0634 2.65742C19.0223 2.7568 19.0011 2.86331 19.0011 2.97088V7.93518C15.7008 8.33912 13.1346 11.1587 13.1346 14.5721C13.1346 14.6797 13.1557 14.7862 13.1969 14.8856C13.238 14.9849 13.2984 15.0752 13.3744 15.1513C13.4505 15.2274 13.5408 15.2877 13.6402 15.3288C13.7396 15.37 13.8461 15.3911 13.9536 15.3911H16.2629C16.5629 17.0906 18.0417 18.3882 19.8258 18.3882C21.6046 18.3882 23.0787 17.0906 23.3777 15.3911H25.6868C25.7944 15.3911 25.9009 15.37 26.0003 15.3288C26.0996 15.2877 26.1899 15.2274 26.266 15.1513C26.3421 15.0752 26.4024 14.9849 26.4435 14.8856C26.4847 14.7862 26.5058 14.6797 26.5058 14.5721C26.5058 11.1618 23.9441 8.34463 20.6393 7.93658V2.971C20.6393 2.51818 20.2725 2.15186 19.8202 2.15186ZM19.8258 16.7501C18.9592 16.7501 18.2204 16.1934 17.9489 15.3912H21.7015C21.4391 16.1799 20.6972 16.7501 19.8258 16.7501ZM24.8017 13.7531H14.839C15.2305 11.3542 17.3137 9.51861 19.8257 9.51861C22.3277 9.51861 24.4098 11.3542 24.8017 13.7531ZM40.181 2.15186C40.0735 2.15182 39.9669 2.17299 39.8676 2.21414C39.7682 2.25529 39.6779 2.31561 39.6018 2.39167C39.5257 2.46773 39.4654 2.55803 39.4243 2.65742C39.3831 2.7568 39.362 2.86331 39.362 2.97088V7.93518C36.0616 8.33912 33.4955 11.1587 33.4955 14.5721C33.4954 14.6797 33.5166 14.7862 33.5578 14.8856C33.5989 14.9849 33.6592 15.0752 33.7353 15.1513C33.8113 15.2274 33.9016 15.2877 34.001 15.3288C34.1004 15.37 34.2069 15.3911 34.3145 15.3911H36.6241C36.924 17.0906 38.4026 18.3882 40.1866 18.3882C41.9654 18.3882 43.4395 17.0906 43.7386 15.3911H46.0477C46.1552 15.3911 46.2617 15.37 46.3611 15.3288C46.4605 15.2877 46.5508 15.2274 46.6269 15.1513C46.7029 15.0752 46.7633 14.9849 46.8044 14.8856C46.8456 14.7862 46.8667 14.6797 46.8667 14.5721C46.8667 11.1618 44.305 8.34463 41.0002 7.93658V2.971C41.0002 2.51818 40.6334 2.15186 40.181 2.15186ZM40.1866 16.7501C39.3204 16.7501 38.5818 16.1934 38.3101 15.3912H42.0622C41.8 16.1799 41.058 16.7501 40.1866 16.7501ZM45.1625 13.7531H35.1998C35.5914 11.3542 37.6746 9.51861 40.1865 9.51861C42.6886 9.51861 44.7707 11.3542 45.1625 13.7531Z"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <h3><a href="hizmet-detay.php">Müteahhitlik</a></h3>
                                <p>Şantiye planlama, tedarik ve kalite kontrol süreçlerini yöneterek söz verdiğimiz sürede güvenle teslim ediyoruz.</p>

                                <a href="hizmet-detay.php" class="more-btn">Hizmeti İncele</a>
                                <a href="hizmet-detay.php" class="arrow">
                                    <svg width="80" height="80" viewBox="0 0 80 80" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path d="M79.604 79.999L0 79.999L-1.30275e-06 65.0973L64.9505 0.000230198L80 0.000228882L80 14.902L35.6436 58.8229L79.604 58.4307L79.604 79.999Z" />
                                            <path d="M0.000577353 -9.57446e-06L0.000581741 50.1953L21.3867 29.0192L21.3867 -1.14441e-05L0.000577353 -9.57446e-06Z" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-3">
                            <div class="service-card2">
                                <div class="icon">
                                    <svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path
                                                d="M30.1208 43.8001H17.2274C15.3341 43.8001 13.8008 42.2668 13.8008 40.3734C13.8008 38.4801 15.3341 36.9468 17.2274 36.9468H30.1208C32.0141 36.9468 33.5474 38.4801 33.5474 40.3734C33.5474 42.2668 32.0141 43.8001 30.1208 43.8001ZM17.2141 38.2801C16.0541 38.2801 15.1208 39.2268 15.1208 40.3734C15.1208 41.5201 16.0674 42.4668 17.2141 42.4668H30.1074C31.2674 42.4668 32.2008 41.5201 32.2008 40.3734C32.2008 39.2268 31.2541 38.2801 30.1074 38.2801H17.2141Z"
                                            />
                                            <path
                                                d="M25.1741 38.2802C24.8008 38.2802 24.5075 37.9868 24.5075 37.6135V34.9335C24.5075 34.5602 24.8008 34.2668 25.1741 34.2668C25.5475 34.2668 25.8408 34.5602 25.8408 34.9335V37.6135C25.8408 37.9868 25.5475 38.2802 25.1741 38.2802ZM22.1608 38.2802C21.7875 38.2802 21.4941 37.9868 21.4941 37.6135V34.9335C21.4941 34.5602 21.7875 34.2668 22.1608 34.2668C22.5341 34.2668 22.8275 34.5602 22.8275 34.9335V37.6135C22.8275 37.9868 22.5341 38.2802 22.1608 38.2802Z"
                                            />
                                            <path
                                                d="M29.9474 35.6001H17.3874C16.1208 35.6001 15.1074 34.5734 15.1074 33.3201V20.2534C15.1074 18.9867 16.1341 17.9734 17.3874 17.9734H29.9474C31.2141 17.9734 32.2274 19.0001 32.2274 20.2534V33.3201C32.2408 34.5734 31.2141 35.6001 29.9474 35.6001ZM17.3874 19.2934C16.8674 19.2934 16.4408 19.7201 16.4408 20.2401V33.3067C16.4408 33.8267 16.8674 34.2534 17.3874 34.2534H29.9474C30.4674 34.2534 30.8941 33.8267 30.8941 33.3067V20.2401C30.8941 19.7201 30.4674 19.2934 29.9474 19.2934H17.3874ZM23.6674 51.5334C23.2941 51.5334 23.0008 51.2401 23.0008 50.8667V43.1334C23.0008 42.7601 23.2941 42.4667 23.6674 42.4667C24.0408 42.4667 24.3341 42.7601 24.3341 43.1334V50.8667C24.3341 51.2401 24.0408 51.5334 23.6674 51.5334Z"
                                            />
                                            <path
                                                d="M30.6797 51.5333C30.3063 51.5333 30.013 51.24 30.013 50.8666V48.0533C30.013 47.84 29.8263 47.6533 29.613 47.6533H17.7197C17.5063 47.6533 17.3197 47.84 17.3197 48.0533V50.8666C17.3197 51.24 17.0263 51.5333 16.653 51.5333C16.2797 51.5333 15.9863 51.24 15.9863 50.8666V48.0533C15.9863 47.1066 16.7597 46.32 17.7197 46.32H29.613C30.5597 46.32 31.3463 47.0933 31.3463 48.0533V50.8666C31.3463 51.24 31.0397 51.5333 30.6797 51.5333ZM25.453 19.2933C25.0797 19.2933 24.7863 19 24.7863 18.6266C24.7863 18.2533 25.0797 17.96 25.453 17.96C26.253 17.96 26.9063 17.3066 26.9063 16.5066C26.9063 15.7066 26.253 15.0533 25.453 15.0533H21.8797C21.0797 15.0533 20.4263 15.7066 20.4263 16.5066C20.4263 17.3066 21.0797 17.96 21.8797 17.96C22.253 17.96 22.5463 18.2533 22.5463 18.6266C22.5463 19 22.253 19.2933 21.8797 19.2933C20.3463 19.2933 19.093 18.04 19.093 16.5066C19.093 14.9733 20.3463 13.72 21.8797 13.72H25.453C26.9863 13.72 28.2397 14.9733 28.2397 16.5066C28.2397 18.04 26.9863 19.2933 25.453 19.2933Z"
                                            />
                                            <path
                                                d="M16.6665 55.5067C15.1999 55.5067 14.0132 54.32 14.0132 52.8533C14.0132 51.3867 15.1999 50.2 16.6665 50.2C18.1332 50.2 19.3199 51.3867 19.3199 52.8533C19.3199 54.32 18.1199 55.5067 16.6665 55.5067ZM16.6665 51.5333C15.9465 51.5333 15.3465 52.12 15.3465 52.8533C15.3465 53.5733 15.9332 54.1733 16.6665 54.1733C17.3865 54.1733 17.9865 53.5867 17.9865 52.8533C17.9732 52.1333 17.3865 51.5333 16.6665 51.5333ZM23.6665 55.5067C22.1999 55.5067 21.0132 54.32 21.0132 52.8533C21.0132 51.3867 22.1999 50.2 23.6665 50.2C25.1332 50.2 26.3199 51.3867 26.3199 52.8533C26.3199 54.32 25.1332 55.5067 23.6665 55.5067ZM23.6665 51.5333C22.9465 51.5333 22.3465 52.12 22.3465 52.8533C22.3465 53.5733 22.9332 54.1733 23.6665 54.1733C24.3999 54.1733 24.9865 53.5867 24.9865 52.8533C24.9865 52.1333 24.3865 51.5333 23.6665 51.5333ZM30.6799 55.5067C29.2132 55.5067 28.0265 54.32 28.0265 52.8533C28.0265 51.3867 29.2132 50.2 30.6799 50.2C32.1465 50.2 33.3332 51.3867 33.3332 52.8533C33.3332 54.32 32.1332 55.5067 30.6799 55.5067ZM30.6799 51.5333C29.9599 51.5333 29.3599 52.12 29.3599 52.8533C29.3599 53.5733 29.9465 54.1733 30.6799 54.1733C31.4132 54.1733 31.9999 53.5867 31.9999 52.8533C31.9865 52.1333 31.3999 51.5333 30.6799 51.5333ZM3.8132 55.5067C2.0132 55.5067 0.533203 54.0267 0.533203 52.2133V28.3467C0.533203 26.5333 2.0132 25.0667 3.8132 25.0667H15.7599C16.1332 25.0667 16.4265 25.36 16.4265 25.7333C16.4265 26.1067 16.1332 26.4 15.7599 26.4H3.8132C2.7332 26.4 1.86654 27.28 1.86654 28.3467V52.2133C1.86654 53.2933 2.74654 54.16 3.8132 54.16C4.87987 54.16 5.75987 53.28 5.75987 52.2133V30.9733C5.75987 30.6 6.0532 30.3067 6.42654 30.3067H15.7599C16.1332 30.3067 16.4265 30.6 16.4265 30.9733C16.4265 31.3467 16.1332 31.64 15.7599 31.64H7.0932V52.2267C7.10654 54.0267 5.62654 55.5067 3.8132 55.5067ZM56.1865 31.64H31.5732C31.1999 31.64 30.9065 31.3467 30.9065 30.9733C30.9065 30.6 31.1999 30.3067 31.5732 30.3067H56.1865C57.2665 30.3067 58.1332 29.4267 58.1332 28.36C58.1332 27.28 57.2532 26.4133 56.1865 26.4133H31.5732C31.1999 26.4133 30.9065 26.12 30.9065 25.7467C30.9065 25.3733 31.1999 25.08 31.5732 25.08H56.1865C57.9999 25.08 59.4665 26.56 59.4665 28.36C59.4665 30.16 57.9865 31.64 56.1865 31.64Z"
                                            />
                                            <path
                                                d="M56.1866 39.5868C55.8132 39.5868 55.5199 39.2935 55.5199 38.9201V30.9601C55.5199 30.5868 55.8132 30.2935 56.1866 30.2935C56.5599 30.2935 56.8532 30.5868 56.8532 30.9601V38.9201C56.8532 39.2935 56.5466 39.5868 56.1866 39.5868ZM40.8932 39.5868C40.5199 39.5868 40.2266 39.2935 40.2266 38.9201V30.9601C40.2266 30.5868 40.5199 30.2935 40.8932 30.2935C41.2666 30.2935 41.5599 30.5868 41.5599 30.9601V38.9201C41.5599 39.2935 41.2666 39.5868 40.8932 39.5868Z"
                                            />
                                            <path
                                                d="M56.1866 47.5468C55.8132 47.5468 55.5199 47.2534 55.5199 46.8801V39.5868H41.5599V46.8801C41.5599 47.2534 41.2666 47.5468 40.8932 47.5468C40.5199 47.5468 40.2266 47.2534 40.2266 46.8801V38.9201C40.2266 38.5468 40.5199 38.2534 40.8932 38.2534H56.1732C56.5466 38.2534 56.8399 38.5468 56.8399 38.9201V46.8801C56.8532 47.2534 56.5466 47.5468 56.1866 47.5468Z"
                                            />
                                            <path
                                                d="M56.1866 55.5067H40.8932C40.5199 55.5067 40.2266 55.2133 40.2266 54.84V46.88C40.2266 46.5067 40.5199 46.2133 40.8932 46.2133H56.1732C56.5466 46.2133 56.8399 46.5067 56.8399 46.88V54.84C56.8532 55.2 56.5466 55.5067 56.1866 55.5067ZM41.5599 54.1733H55.5066V47.5467H41.5599V54.1733ZM47.0666 26.4C46.6932 26.4 46.3999 26.1067 46.3999 25.7333V23.08C46.3999 22.7067 46.6932 22.4133 47.0666 22.4133C47.4399 22.4133 47.7332 22.7067 47.7332 23.08V25.7333C47.7332 26.0933 47.4399 26.4 47.0666 26.4ZM41.9999 26.4C41.6266 26.4 41.3332 26.1067 41.3332 25.7333V23.08C41.3332 22.7067 41.6266 22.4133 41.9999 22.4133C42.3732 22.4133 42.6666 22.7067 42.6666 23.08V25.7333C42.6666 26.0933 42.3732 26.4 41.9999 26.4Z"
                                            />
                                            <path
                                                d="M56.4394 23.7467H32.6261C32.1594 23.7467 31.6928 23.6401 31.2661 23.4267C30.9328 23.2667 30.8128 22.8534 30.9728 22.5334C31.1328 22.2001 31.5461 22.0667 31.8661 22.2401C32.1061 22.3601 32.3594 22.4267 32.6261 22.4267H56.4394C57.3728 22.4267 58.1328 21.6667 58.1328 20.7334V7.53341C58.1328 6.60007 57.3728 5.84007 56.4394 5.84007H32.6261C31.6928 5.84007 30.9328 6.60007 30.9328 7.53341V18.6667C30.9328 19.0401 30.6394 19.3334 30.2661 19.3334C29.8928 19.3334 29.5994 19.0401 29.5994 18.6667V7.52007C29.5994 5.85341 30.9594 4.49341 32.6261 4.49341H56.4394C58.1061 4.49341 59.4661 5.85341 59.4661 7.52007V20.7201C59.4661 22.3867 58.1061 23.7467 56.4394 23.7467ZM9.45276 26.4001C7.41276 26.4001 5.74609 24.7467 5.74609 22.6934V19.3334C5.74609 18.9601 6.03943 18.6667 6.41276 18.6667H12.4794C12.8528 18.6667 13.1461 18.9601 13.1461 19.3334V22.6934C13.1594 24.7334 11.4928 26.4001 9.45276 26.4001ZM7.09276 20.0134V22.7067C7.09276 24.0134 8.15943 25.0801 9.46609 25.0801C10.7728 25.0801 11.8394 24.0134 11.8394 22.7067V20.0134H7.09276Z"
                                            />
                                            <path
                                                d="M5.70622 23.9467C5.06622 23.9467 4.47956 23.76 4.02622 23.4C3.50622 22.9867 3.21289 22.3733 3.21289 21.7333V20.6667C3.21289 20.2933 3.50622 20 3.87956 20H6.41289C6.78622 20 7.07956 20.2933 7.07956 20.6667C7.07956 21.04 6.78622 21.3333 6.41289 21.3333H4.54622V21.7333C4.54622 21.9867 4.65289 22.2 4.85289 22.36C5.17289 22.6133 5.67956 22.68 6.26622 22.5467C6.62622 22.4667 6.98622 22.6933 7.06622 23.04C7.14622 23.4 6.91956 23.76 6.57289 23.84C6.27956 23.9067 5.98622 23.9467 5.70622 23.9467ZM26.6396 24.52H20.7062C20.3329 24.52 20.0396 24.2267 20.0396 23.8533C20.0396 23.48 20.3329 23.1867 20.7062 23.1867H26.6396C27.0129 23.1867 27.3062 23.48 27.3062 23.8533C27.3062 24.2267 26.9996 24.52 26.6396 24.52ZM26.6396 27.4533H20.7062C20.3329 27.4533 20.0396 27.16 20.0396 26.7867C20.0396 26.4133 20.3329 26.12 20.7062 26.12H26.6396C27.0129 26.12 27.3062 26.4133 27.3062 26.7867C27.3062 27.16 26.9996 27.4533 26.6396 27.4533ZM26.6396 30.3867H20.7062C20.3329 30.3867 20.0396 30.0933 20.0396 29.72C20.0396 29.3467 20.3329 29.0533 20.7062 29.0533H26.6396C27.0129 29.0533 27.3062 29.3467 27.3062 29.72C27.3062 30.0933 26.9996 30.3867 26.6396 30.3867ZM50.8396 35.6133H46.2396C45.8662 35.6133 45.5729 35.32 45.5729 34.9467C45.5729 34.5733 45.8662 34.28 46.2396 34.28H50.8396C51.2129 34.28 51.5062 34.5733 51.5062 34.9467C51.5062 35.32 51.2129 35.6133 50.8396 35.6133ZM50.8396 43.5733H46.2396C45.8662 43.5733 45.5729 43.28 45.5729 42.9067C45.5729 42.5333 45.8662 42.24 46.2396 42.24H50.8396C51.2129 42.24 51.5062 42.5333 51.5062 42.9067C51.5062 43.28 51.2129 43.5733 50.8396 43.5733ZM50.8396 51.52H46.2396C45.8662 51.52 45.5729 51.2267 45.5729 50.8533C45.5729 50.48 45.8662 50.1867 46.2396 50.1867H50.8396C51.2129 50.1867 51.5062 50.48 51.5062 50.8533C51.5062 51.2267 51.2129 51.52 50.8396 51.52Z"
                                            />
                                        </g>
                                    </svg>
                                </div>
                                <h3><a href="hizmet-detay.php">Proje Yönetimi</a></h3>
                                <p>Bütçe, zaman ve kapsamı tek merkezden izleyip riskleri azaltarak projenizi şeffaf ve verimli şekilde yürütüyoruz.</p>

                                <a href="hizmet-detay.php" class="more-btn">Hizmeti İncele</a>
                                <a href="hizmet-detay.php" class="arrow">
                                    <svg width="80" height="80" viewBox="0 0 80 80" xmlns="http://www.w3.org/2000/svg">
                                        <g>
                                            <path d="M79.604 79.999L0 79.999L-1.30275e-06 65.0973L64.9505 0.000230198L80 0.000228882L80 14.902L35.6436 58.8229L79.604 58.4307L79.604 79.999Z" />
                                            <path d="M0.000577353 -9.57446e-06L0.000581741 50.1953L21.3867 29.0192L21.3867 -1.14441e-05L0.000577353 -9.57446e-06Z" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Home1 Footer Section End -->
        <?php include 'partials/footer.php'; ?>
        <!-- Home1 Footer Section End -->

        <!--  Main jQuery  -->
        <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
        <script src="assets/js/jquery-3.7.1.min.js"></script>
        <!-- Popper and Bootstrap JS -->
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <!-- Swiper slider JS -->
        <script src="assets/js/swiper-bundle.min.js"></script>
        <script src="assets/js/slick.min.js"></script>
        <!-- Waypoints JS -->
        <script src="assets/js/waypoints.min.js"></script>
        <!-- Counterup JS -->
        <script src="assets/js/jquery.counterup.min.js"></script>
        <!-- Nice Select  JS -->
        <script src="assets/js/jquery.nice-select.min.js"></script>
        <!-- Fancybox  JS -->
        <script src="assets/js/jquery.fancybox.min.js"></script>
        <!-- Wow  JS -->
        <script src="assets/js/wow.min.js"></script>
        <!-- Marquee  JS -->
        <script src="assets/js/jquery.marquee.min.js"></script>
        <!-- GSAP  JS -->
        <script src="assets/js/gsap.min.js"></script>
        <script src="assets/js/ScrollTrigger.min.js"></script>
        <script src="assets/js/simpleParallax.min.js"></script>
        <!-- <script src="assets/js/SmoothScroll.js"></script> -->
        <script src="assets/js/TweenMax.min.js"></script>
        <script src="assets/js/SplitText.min.js"></script>

        <script src="assets/js/main.js"></script>
    </body>
</html>
